/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import com.annimon.stream.function.Supplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.tools.iosource.InputReader;
import schemacrawler.tools.iosource.InputResource;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public class FileInputResource
implements InputResource {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)FileInputResource.class.getName());
    private final Path inputFile;

    public FileInputResource(Path filePath) throws IOException {
        this.inputFile = Objects.requireNonNull(filePath, "No file path provided").normalize().toAbsolutePath();
        if (!IOUtility.isFileReadable((Path)this.inputFile)) {
            IOException e = new IOException("Cannot read file, " + this.inputFile);
            LOGGER.log(Level.CONFIG, e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Path getInputFile() {
        return this.inputFile;
    }

    @Override
    public Reader openNewInputReader(Charset charset) throws IOException {
        Objects.requireNonNull(charset, "No input charset provided");
        BufferedReader reader = Files.newBufferedReader(this.inputFile, charset);
        LOGGER.log(Level.INFO, (Supplier)new StringFormat("Opened input reader to file <%s>", new Object[]{this.inputFile}));
        return new InputReader(this.getDescription(), reader, true);
    }

    public String toString() {
        return this.getDescription();
    }

    private String getDescription() {
        return this.inputFile.toString();
    }
}

