/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import com.annimon.stream.function.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import schemacrawler.tools.iosource.InputReader;
import schemacrawler.tools.iosource.InputResource;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public class CompressedFileInputResource
implements InputResource {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)CompressedFileInputResource.class.getName());
    private final Path inputFile;
    private final String internalPath;

    public CompressedFileInputResource(Path filePath, String internalPath) throws IOException {
        this.inputFile = Objects.requireNonNull(filePath, "No file path provided").normalize().toAbsolutePath();
        if (!IOUtility.isFileReadable((Path)this.inputFile)) {
            IOException e = new IOException("Cannot read file, " + this.inputFile);
            LOGGER.log(Level.CONFIG, e.getMessage(), (Throwable)e);
            throw e;
        }
        this.internalPath = Objects.requireNonNull(internalPath, "No internal file path provided");
    }

    public Path getInputFile() {
        return this.inputFile;
    }

    @Override
    public Reader openNewInputReader(Charset charset) throws IOException {
        InputStream fileStream = Files.newInputStream(this.inputFile, new OpenOption[0]);
        ZipInputStream zipInputStream = new ZipInputStream(fileStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null || !zipEntry.getName().equals(this.internalPath)) {
            throw new IOException("Zip file does not contain " + this.internalPath);
        }
        InputStreamReader reader = new InputStreamReader((InputStream)zipInputStream, charset);
        LOGGER.log(Level.INFO, (Supplier)new StringFormat("Opened input reader to compressed file <%s>", new Object[]{this.inputFile}));
        return new InputReader(this.getDescription(), reader, true);
    }

    public String toString() {
        return this.getDescription();
    }

    private String getDescription() {
        return this.inputFile.toString();
    }
}

