/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.tools.iosource.InputReader;
import schemacrawler.tools.iosource.InputResource;
import sf.util.SchemaCrawlerLogger;

public class ClasspathInputResource
implements InputResource {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)ClasspathInputResource.class.getName());
    private final String classpathResource;

    public ClasspathInputResource(String classpathResource) throws IOException {
        this.classpathResource = Objects.requireNonNull(classpathResource, "No classpath resource provided");
        if (ClasspathInputResource.class.getResource(this.classpathResource) == null) {
            IOException e = new IOException("Cannot read classpath resource, " + this.classpathResource);
            LOGGER.log(Level.CONFIG, e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Reader openNewInputReader(Charset charset) throws IOException {
        Objects.requireNonNull(charset, "No input charset provided");
        InputStream inputStream = ClasspathInputResource.class.getResourceAsStream(this.classpathResource);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        LOGGER.log(Level.INFO, "Opened input reader to classpath resource, " + this.classpathResource);
        return new InputReader(this.getDescription(), reader, true);
    }

    public String toString() {
        return this.getDescription();
    }

    private String getDescription() {
        return InputReader.class.getResource(this.classpathResource).toExternalForm();
    }
}

