/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Table;

final class ForeignKeys {
    private final Collection<ColumnReference> foreignKeys;

    ForeignKeys(List<Table> tables) {
        this.foreignKeys = this.mapForeignKeyColumns(tables);
    }

    public boolean contains(ColumnReference columnMap) {
        if (columnMap == null) {
            return false;
        }
        for (ColumnReference foreignKey : this.foreignKeys) {
            boolean equals = columnMap.equals(foreignKey);
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.foreignKeys.toString();
    }

    private Collection<ColumnReference> mapForeignKeyColumns(List<Table> tables) {
        Objects.requireNonNull(tables);
        HashSet<ColumnReference> fkColumnsMap = new HashSet<ColumnReference>();
        for (Table table : tables) {
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                for (ForeignKeyColumnReference columnRef : foreignKey) {
                    fkColumnsMap.add((ColumnReference)columnRef);
                }
            }
        }
        return fkColumnsMap;
    }
}

