/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public class PropertiesUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(PropertiesUtility.class.getName());

    public static Properties loadProperties(Path propertiesFile) {
        if (!IOUtility.isFileReadable(propertiesFile)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Cannot load properties from file <%s>", propertiesFile));
            return new Properties();
        }
        LOGGER.log(Level.INFO, new StringFormat("Loading properties from file <%s>", propertiesFile));
        try {
            BufferedReader reader = Files.newBufferedReader(propertiesFile, StandardCharsets.UTF_8);
            Properties properties = PropertiesUtility.loadProperties(reader);
            return properties;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, new StringFormat("Cannot load properties from file <%s>", propertiesFile), (Throwable)e);
            return new Properties();
        }
    }

    public static Properties loadProperties(String resource) {
        if (Utility.isBlank(resource)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Cannot load properties from resource <%s>", resource));
            return new Properties();
        }
        InputStream stream = Config.class.getResourceAsStream(resource);
        Properties properties = stream != null ? PropertiesUtility.loadProperties(new InputStreamReader(stream, StandardCharsets.UTF_8)) : new Properties();
        return properties;
    }

    private static Properties loadProperties(Reader reader) {
        Objects.requireNonNull(reader);
        Properties properties = new Properties();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            properties.load(bufferedReader);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error loading properties", (Throwable)e);
        }
        return properties;
    }
}

