/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import com.annimon.stream.function.Supplier;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import sf.util.IOUtility;

public final class FileContents
implements Supplier<String> {
    private final Path file;
    private final Charset charset;

    public FileContents(Path file) {
        this(file, Charset.defaultCharset());
    }

    public FileContents(Path file, Charset charset) {
        this.file = Objects.requireNonNull(file, "No file path provided");
        this.charset = Objects.requireNonNull(charset, "No charset provided");
    }

    public String get() {
        String output;
        try {
            output = !IOUtility.isFileReadable(this.file) ? "" : new String(Files.readAllBytes(this.file), this.charset);
        }
        catch (IOException e) {
            return "";
        }
        return output;
    }

    public String toString() {
        return this.get();
    }
}

