/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import com.annimon.stream.Optional;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import sf.util.Utility;

public final class SchemaReference
implements Schema {
    private static final long serialVersionUID = -5309848447599233878L;
    private final String catalogName;
    private final String schemaName;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();

    public SchemaReference() {
        this(null, null);
    }

    public SchemaReference(String catalogName, String schemaName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public int compareTo(NamedObject otherSchemaRef) {
        if (otherSchemaRef == null) {
            return -1;
        }
        return Utility.convertForComparison(this.getFullName()).compareTo(Utility.convertForComparison(otherSchemaRef.getFullName()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaReference other = (SchemaReference)obj;
        if (this.attributeMap == null ? other.attributeMap != null : !this.attributeMap.equals(other.attributeMap)) {
            return false;
        }
        if (this.catalogName == null ? other.catalogName != null : !this.catalogName.equals(other.catalogName)) {
            return false;
        }
        return !(this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName));
    }

    @Override
    public final <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public final <T> T getAttribute(String name, T defaultValue) {
        Object attributeValue = this.attributeMap.get(name);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return (T)attributeValue;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getFullName() {
        boolean hasSchemaName;
        StringBuilder buffer = new StringBuilder(64);
        boolean hasCatalogName = !Utility.isBlank(this.catalogName);
        boolean bl = hasSchemaName = !Utility.isBlank(this.getName());
        if (hasCatalogName) {
            buffer.append(this.catalogName);
        }
        if (hasCatalogName && hasSchemaName) {
            buffer.append(".");
        }
        if (hasSchemaName) {
            buffer.append(this.getName());
        }
        return buffer.toString();
    }

    @Override
    public String getLookupKey() {
        return this.getFullName();
    }

    @Override
    public String getName() {
        return this.schemaName;
    }

    @Override
    public String getRemarks() {
        return "";
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeMap == null ? 0 : this.attributeMap.hashCode());
        result = 31 * result + (this.catalogName == null ? 0 : this.catalogName.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        return result;
    }

    @Override
    public boolean hasRemarks() {
        return false;
    }

    @Override
    public final <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }

    @Override
    public final void removeAttribute(String name) {
        if (!Utility.isBlank(name)) {
            this.attributeMap.remove(name);
        }
    }

    public final void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    public String toString() {
        return this.getFullName();
    }
}

