/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.annimon.stream.Optional;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnReference;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TableReference;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.CheckOptionType;
import schemacrawler.schema.Column;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class TableExtRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableExtRetriever.class.getName());

    TableExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveAdditionalColumnAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasAdditionalColumnAttributesSql()) {
            LOGGER.log(Level.INFO, "Not retrieving additional column attributes, since this was not requested");
            LOGGER.log(Level.FINE, "Additional column attributes SQL statement was not provided");
            return;
        }
        Query columnAttributesSql = informationSchemaViews.getAdditionalColumnAttributesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(columnAttributesSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.nameQuotedName(results.getString("TABLE_CATALOG"));
                String schemaName = this.nameQuotedName(results.getString("TABLE_SCHEMA"));
                String tableName = this.nameQuotedName(results.getString("TABLE_NAME"));
                String columnName = this.nameQuotedName(results.getString("COLUMN_NAME"));
                LOGGER.log(Level.FINER, "Retrieving additional column attributes: " + columnName);
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
                    continue;
                }
                MutableTable table = (MutableTable)tableOptional.get();
                Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
                if (!columnOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find column <%s.%s.%s.%s>", catalogName, schemaName, tableName, columnName));
                    continue;
                }
                MutableColumn column = (MutableColumn)columnOptional.get();
                column.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional column attributes", (Throwable)e);
        }
    }

    void retrieveAdditionalTableAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasAdditionalTableAttributesSql()) {
            LOGGER.log(Level.INFO, "Not retrieving additional table attributes, since this was not requested");
            LOGGER.log(Level.FINE, "Additional table attributes SQL statement was not provided");
            return;
        }
        Query tableAttributesSql = informationSchemaViews.getAdditionalTableAttributesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableAttributesSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.nameQuotedName(results.getString("TABLE_CATALOG"));
                String schemaName = this.nameQuotedName(results.getString("TABLE_SCHEMA"));
                String tableName = this.nameQuotedName(results.getString("TABLE_NAME"));
                LOGGER.log(Level.FINER, "Retrieving additional table attributes: " + tableName);
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
                    continue;
                }
                MutableTable table = (MutableTable)tableOptional.get();
                table.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional table attributes", (Throwable)e);
        }
    }

    void retrieveIndexColumnInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasExtIndexColumnsSql()) {
            LOGGER.log(Level.INFO, "Not retrieving additional index column information, since this was not requested");
            LOGGER.log(Level.FINE, "Index column information SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional index column information");
        Query extIndexColumnsInformationSql = informationSchemaViews.getExtIndexColumnsSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(extIndexColumnsInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String indexColumnName;
                String catalogName = this.nameQuotedName(results.getString("INDEX_CATALOG"));
                String schemaName = this.nameQuotedName(results.getString("INDEX_SCHEMA"));
                String tableName = this.nameQuotedName(results.getString("TABLE_NAME"));
                String indexName = this.nameQuotedName(results.getString("INDEX_NAME"));
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, indexName));
                    continue;
                }
                LOGGER.log(Level.FINER, new StringFormat("Retrieving index information <%s>", indexName));
                MutableTable table = (MutableTable)tableOptional.get();
                Optional<MutableIndex> indexOptional = table.lookupIndex(indexName);
                if (!indexOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find index <%s.%s.%s.%s>", catalogName, schemaName, tableName, indexName));
                    continue;
                }
                MutableIndex index = (MutableIndex)indexOptional.get();
                Optional<MutableIndexColumn> indexColumnOptional = index.lookupColumn(indexColumnName = this.nameQuotedName(results.getString("COLUMN_NAME")));
                if (!indexColumnOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find index column <%s.%s.%s.%s.%s>", catalogName, schemaName, tableName, indexName, indexColumnName));
                    continue;
                }
                MutableIndexColumn indexColumn = (MutableIndexColumn)indexColumnOptional.get();
                String definition = results.getString("INDEX_COLUMN_DEFINITION");
                indexColumn.appendDefinition(definition);
                indexColumn.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve index information", (Throwable)e);
        }
    }

    void retrieveIndexInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasExtIndexesSql()) {
            LOGGER.log(Level.INFO, "Not retrieving additional index information, since this was not requested");
            LOGGER.log(Level.FINE, "Indexes information SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional index information");
        Query extIndexesInformationSql = informationSchemaViews.getExtIndexesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(extIndexesInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.nameQuotedName(results.getString("INDEX_CATALOG"));
                String schemaName = this.nameQuotedName(results.getString("INDEX_SCHEMA"));
                String tableName = this.nameQuotedName(results.getString("TABLE_NAME"));
                String indexName = this.nameQuotedName(results.getString("INDEX_NAME"));
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, indexName));
                    continue;
                }
                LOGGER.log(Level.FINER, new StringFormat("Retrieving index information <%s>", indexName));
                MutableTable table = (MutableTable)tableOptional.get();
                Optional<MutableIndex> indexOptional = table.lookupIndex(indexName);
                if (!indexOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find index <%s.%s.%s.%s>", catalogName, schemaName, tableName, indexName));
                    continue;
                }
                MutableIndex index = (MutableIndex)indexOptional.get();
                String definition = results.getString("INDEX_DEFINITION");
                String remarks = results.getString("REMARKS");
                index.appendDefinition(definition);
                index.setRemarks(remarks);
                index.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve index information", (Throwable)e);
        }
    }

    void retrievePrimaryKeyDefinitions(NamedObjectList<MutableTable> allTables) {
        Objects.requireNonNull(allTables);
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        Connection connection = this.getDatabaseConnection();
        if (!informationSchemaViews.hasExtPrimaryKeysSql()) {
            LOGGER.log(Level.FINE, "Extended primary keys SQL statement was not provided");
            return;
        }
        NamedObjectList<MutablePrimaryKey> allPks = new NamedObjectList<MutablePrimaryKey>();
        for (MutableTable table : allTables) {
            if (!table.hasPrimaryKey()) continue;
            MutablePrimaryKey primaryKey = table.getPrimaryKey();
            allPks.add(primaryKey);
        }
        Query extPrimaryKeysSql = informationSchemaViews.getExtPrimaryKeysSql();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(extPrimaryKeysSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.nameQuotedName(results.getString("PRIMARY_KEY_CATALOG"));
                String schemaName = this.nameQuotedName(results.getString("PRIMARY_KEY_SCHEMA"));
                String tableName = this.nameQuotedName(results.getString("PRIMARY_KEY_TABLE_NAME"));
                String pkName = this.nameQuotedName(results.getString("PRIMARY_KEY_NAME"));
                String constraintKey = new SchemaReference(catalogName, schemaName) + "." + tableName + "." + pkName;
                LOGGER.log(Level.FINER, new StringFormat("Retrieving definition of primary key <%s>", constraintKey));
                String definition = results.getString("PRIMARY_KEY_DEFINITION");
                Optional optionalPk = allPks.lookup(constraintKey);
                if (optionalPk.isPresent()) {
                    MutablePrimaryKey pkConstraint = (MutablePrimaryKey)optionalPk.get();
                    pkConstraint.appendDefinition(definition);
                    pkConstraint.addAttributes(results.getAttributes());
                    continue;
                }
                LOGGER.log(Level.FINER, new StringFormat("Could not find primary key <%s>", constraintKey));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", (Throwable)e);
        }
    }

    void retrieveTableColumnPrivileges() throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getColumnPrivileges(null, null, "%", "%"));){
            this.createPrivileges(results, true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table column privileges:" + e.getMessage());
        }
    }

    void retrieveTableDefinitions() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasExtTablesSql()) {
            LOGGER.log(Level.INFO, "Not retrieving table definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Table definitions SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving table definitions");
        Query tableDefinitionsInformationSql = informationSchemaViews.getExtTablesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableDefinitionsInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String tableName;
                String schemaName;
                String catalogName = this.nameQuotedName(results.getString("TABLE_CATALOG"));
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName = this.nameQuotedName(results.getString("TABLE_SCHEMA")), tableName = this.nameQuotedName(results.getString("TABLE_NAME")));
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
                    continue;
                }
                MutableTable table = (MutableTable)tableOptional.get();
                LOGGER.log(Level.FINER, new StringFormat("Retrieving table information <%s>", tableName));
                String definition = results.getString("TABLE_DEFINITION");
                table.appendDefinition(definition);
                table.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table definitions", (Throwable)e);
        }
    }

    void retrieveTablePrivileges() throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getTablePrivileges(null, null, "%"));){
            this.createPrivileges(results, false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table privileges", (Throwable)e);
        }
    }

    void retrieveTriggerInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTriggerSql()) {
            LOGGER.log(Level.INFO, "Not retrieving trigger definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Trigger definition SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving trigger definitions");
        Query triggerInformationSql = informationSchemaViews.getTriggersSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(triggerInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.nameQuotedName(results.getString("TRIGGER_CATALOG"));
                String schemaName = this.nameQuotedName(results.getString("TRIGGER_SCHEMA"));
                String triggerName = this.nameQuotedName(results.getString("TRIGGER_NAME"));
                LOGGER.log(Level.FINER, new StringFormat("Retrieving trigger <%s>", triggerName));
                String tableName = results.getString("EVENT_OBJECT_TABLE");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
                    continue;
                }
                MutableTable table = (MutableTable)tableOptional.get();
                EventManipulationType eventManipulationType = results.getEnum("EVENT_MANIPULATION", EventManipulationType.unknown);
                int actionOrder = results.getInt("ACTION_ORDER", 0);
                String actionCondition = results.getString("ACTION_CONDITION");
                String actionStatement = results.getString("ACTION_STATEMENT");
                ActionOrientationType actionOrientation = results.getEnum("ACTION_ORIENTATION", ActionOrientationType.unknown);
                String conditionTimingString = results.getString("ACTION_TIMING");
                if (conditionTimingString == null) {
                    conditionTimingString = results.getString("CONDITION_TIMING");
                }
                ConditionTimingType conditionTiming = ConditionTimingType.valueOfFromValue(conditionTimingString);
                MutableTrigger trigger = (MutableTrigger)table.lookupTrigger(triggerName).orElse((Object)new MutableTrigger(table, triggerName));
                trigger.setEventManipulationType(eventManipulationType);
                trigger.setActionOrder(actionOrder);
                trigger.appendActionCondition(actionCondition);
                trigger.appendActionStatement(actionStatement);
                trigger.setActionOrientation(actionOrientation);
                trigger.setConditionTiming(conditionTiming);
                trigger.addAttributes(results.getAttributes());
                table.addTrigger(trigger);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve triggers", (Throwable)e);
        }
    }

    void retrieveViewInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasViewsSql()) {
            LOGGER.log(Level.INFO, "Not retrieving additional view information, since this was not requested");
            LOGGER.log(Level.FINE, "Views SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional view information");
        Query viewInformationSql = informationSchemaViews.getViewsSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(viewInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String viewName;
                String schemaName;
                String catalogName = this.nameQuotedName(results.getString("TABLE_CATALOG"));
                Optional<MutableTable> viewOptional = this.lookupTable(catalogName, schemaName = this.nameQuotedName(results.getString("TABLE_SCHEMA")), viewName = this.nameQuotedName(results.getString("TABLE_NAME")));
                if (!viewOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, viewName));
                    continue;
                }
                MutableView view = (MutableView)viewOptional.get();
                LOGGER.log(Level.FINER, new StringFormat("Retrieving view information <%s>", viewName));
                String definition = results.getString("VIEW_DEFINITION");
                CheckOptionType checkOption = results.getEnum("CHECK_OPTION", CheckOptionType.unknown);
                boolean updatable = results.getBoolean("IS_UPDATABLE");
                view.appendDefinition(definition);
                view.setCheckOption(checkOption);
                view.setUpdatable(updatable);
                view.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve views", (Throwable)e);
        }
    }

    private void createPrivileges(MetadataResultSet results, boolean privilegesForColumn) throws SQLException {
        while (results.next()) {
            MutablePrivilege privilege;
            Object privilegeOptional;
            MutableColumn column;
            String catalogName = this.nameQuotedName(results.getString("TABLE_CAT"));
            String schemaName = this.nameQuotedName(results.getString("TABLE_SCHEM"));
            String tableName = this.nameQuotedName(results.getString("TABLE_NAME"));
            String columnName = privilegesForColumn ? this.nameQuotedName(results.getString("COLUMN_NAME")) : null;
            Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
            if (!tableOptional.isPresent()) continue;
            MutableTable table = (MutableTable)tableOptional.get();
            if (privilegesForColumn) {
                Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
                if (!columnOptional.isPresent()) continue;
                column = (MutableColumn)columnOptional.get();
            } else {
                column = null;
            }
            String privilegeName = results.getString("PRIVILEGE");
            String grantor = results.getString("GRANTOR");
            String grantee = results.getString("GRANTEE");
            boolean isGrantable = results.getBoolean("IS_GRANTABLE");
            if (privilegesForColumn) {
                privilegeOptional = column.lookupPrivilege(privilegeName);
                privilege = (MutablePrivilege)privilegeOptional.orElse(new MutablePrivilege<Column>(new ColumnReference(column), privilegeName));
            } else {
                privilegeOptional = table.lookupPrivilege(privilegeName);
                privilege = (MutablePrivilege)privilegeOptional.orElse(new MutablePrivilege<Table>(new TableReference(table), privilegeName));
            }
            privilege.addGrant(grantor, grantee, isGrantable);
            if (privilegesForColumn) {
                column.addPrivilege(privilege);
                continue;
            }
            table.addPrivilege(privilege);
        }
    }
}

