/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.model.sources;

import java.util.List;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.model.FieldExtractor;

public interface Source {
    public String getText(Page var1, String var2, boolean var3, FieldExtractor var4);

    public List<String> getTextList(Page var1, String var2, boolean var3, FieldExtractor var4);

    public static class DefaultSource
    implements Source {
        @Override
        public String getText(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            return fieldExtractor.getSelector().select(html);
        }

        @Override
        public List<String> getTextList(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            return fieldExtractor.getSelector().selectList(html);
        }
    }

    public static class RawText
    implements Source {
        @Override
        public String getText(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            return fieldExtractor.getSelector().select(page.getRawText());
        }

        @Override
        public List<String> getTextList(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            return fieldExtractor.getSelector().selectList(page.getRawText());
        }
    }

    public static class Url
    implements Source {
        @Override
        public String getText(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            return fieldExtractor.getSelector().select(page.getUrl().toString());
        }

        @Override
        public List<String> getTextList(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            return fieldExtractor.getSelector().selectList(page.getUrl().toString());
        }
    }

    public static class SelectedHtml
    implements Source {
        @Override
        public String getText(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            if (isRaw) {
                return page.getHtml().selectDocument(fieldExtractor.getSelector());
            }
            return fieldExtractor.getSelector().select(html);
        }

        @Override
        public List<String> getTextList(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            if (isRaw) {
                return page.getHtml().selectDocumentForList(fieldExtractor.getSelector());
            }
            return fieldExtractor.getSelector().selectList(html);
        }
    }

    public static class RawHtml
    implements Source {
        @Override
        public String getText(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            return page.getHtml().selectDocument(fieldExtractor.getSelector());
        }

        @Override
        public List<String> getTextList(Page page, String html, boolean isRaw, FieldExtractor fieldExtractor) {
            return page.getHtml().selectDocumentForList(fieldExtractor.getSelector());
        }
    }
}

