/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.DuplicateRemovedScheduler;
import us.codecraft.webmagic.scheduler.MonitorableScheduler;
import us.codecraft.webmagic.scheduler.component.DuplicateRemover;

public class FileCacheQueueScheduler
extends DuplicateRemovedScheduler
implements MonitorableScheduler,
Closeable {
    private String filePath = System.getProperty("java.io.tmpdir");
    private String fileUrlAllName = ".urls.txt";
    private Task task;
    private String fileCursor = ".cursor.txt";
    private PrintWriter fileUrlWriter;
    private PrintWriter fileCursorWriter;
    private AtomicInteger cursor = new AtomicInteger();
    private AtomicBoolean inited = new AtomicBoolean(false);
    private BlockingQueue<Request> queue;
    private Set<String> urls;
    private ScheduledExecutorService flushThreadPool;

    public FileCacheQueueScheduler(String filePath) {
        if (!((String)filePath).endsWith("/") && !((String)filePath).endsWith("\\")) {
            filePath = (String)filePath + "/";
        }
        this.filePath = filePath;
        this.initDuplicateRemover();
    }

    private void flush() {
        this.fileUrlWriter.flush();
        this.fileCursorWriter.flush();
    }

    private void init(Task task) {
        this.task = task;
        File file = new File(this.filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.readFile();
        this.initWriter();
        this.initFlushThread();
        this.inited.set(true);
        this.logger.info("init cache scheduler success");
    }

    private void initDuplicateRemover() {
        this.setDuplicateRemover(new DuplicateRemover(){

            public boolean isDuplicate(Request request, Task task) {
                if (!FileCacheQueueScheduler.this.inited.get()) {
                    FileCacheQueueScheduler.this.init(task);
                }
                return !FileCacheQueueScheduler.this.urls.add(request.getUrl());
            }

            public void resetDuplicateCheck(Task task) {
                FileCacheQueueScheduler.this.urls.clear();
            }

            public int getTotalRequestsCount(Task task) {
                return FileCacheQueueScheduler.this.urls.size();
            }
        });
    }

    private void initFlushThread() {
        this.flushThreadPool = Executors.newScheduledThreadPool(1);
        this.flushThreadPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                FileCacheQueueScheduler.this.flush();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private void initWriter() {
        try {
            this.fileUrlWriter = new PrintWriter(new FileWriter(this.getFileName(this.fileUrlAllName), true));
            this.fileCursorWriter = new PrintWriter(new FileWriter(this.getFileName(this.fileCursor), false));
        }
        catch (IOException e) {
            throw new RuntimeException("init cache scheduler error", e);
        }
    }

    private void readFile() {
        try {
            this.queue = new LinkedBlockingQueue<Request>();
            this.urls = new LinkedHashSet<String>();
            this.readCursorFile();
            this.readUrlFile();
        }
        catch (FileNotFoundException e) {
            this.logger.info("init cache file " + this.getFileName(this.fileUrlAllName));
        }
        catch (IOException e) {
            this.logger.error("init file error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readUrlFile() throws IOException {
        BufferedReader fileUrlReader = null;
        try {
            String line;
            fileUrlReader = new BufferedReader(new FileReader(this.getFileName(this.fileUrlAllName)));
            int lineReaded = 0;
            while ((line = fileUrlReader.readLine()) != null) {
                this.urls.add(line.trim());
                if (++lineReaded <= this.cursor.get()) continue;
                this.queue.add(this.deserializeRequest(line));
            }
            if (fileUrlReader == null) return;
        }
        catch (Throwable throwable) {
            if (fileUrlReader == null) throw throwable;
            IOUtils.closeQuietly(fileUrlReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)fileUrlReader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readCursorFile() throws IOException {
        BufferedReader fileCursorReader = null;
        try {
            String line;
            fileCursorReader = new BufferedReader(new FileReader(this.getFileName(this.fileCursor)));
            while ((line = fileCursorReader.readLine()) != null) {
                this.cursor = new AtomicInteger(NumberUtils.toInt((String)line));
            }
            if (fileCursorReader == null) return;
        }
        catch (Throwable throwable) {
            if (fileCursorReader == null) throw throwable;
            IOUtils.closeQuietly(fileCursorReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)fileCursorReader);
    }

    @Override
    public void close() throws IOException {
        this.flushThreadPool.shutdown();
        this.fileUrlWriter.close();
        this.fileCursorWriter.close();
    }

    private String getFileName(String filename) {
        return this.filePath + this.task.getUUID() + filename;
    }

    protected void pushWhenNoDuplicate(Request request, Task task) {
        if (!this.inited.get()) {
            this.init(task);
        }
        this.queue.add(request);
        this.fileUrlWriter.println(this.serializeRequest(request));
    }

    public synchronized Request poll(Task task) {
        if (!this.inited.get()) {
            this.init(task);
        }
        this.fileCursorWriter.println(this.cursor.incrementAndGet());
        return (Request)this.queue.poll();
    }

    public int getLeftRequestsCount(Task task) {
        return this.queue.size();
    }

    public int getTotalRequestsCount(Task task) {
        return this.getDuplicateRemover().getTotalRequestsCount(task);
    }

    protected String serializeRequest(Request request) {
        return request.getUrl();
    }

    protected Request deserializeRequest(String line) {
        return new Request(line);
    }
}

