/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.model.PageModelExtractor;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Selector;

class ModelPageProcessor
implements PageProcessor {
    private List<PageModelExtractor> pageModelExtractorList = new ArrayList<PageModelExtractor>();
    private Site site;
    private Set<Pattern> targetUrlPatterns = new HashSet<Pattern>();

    public static ModelPageProcessor create(Site site, Class ... clazzs) {
        ModelPageProcessor modelPageProcessor = new ModelPageProcessor(site);
        for (Class clazz : clazzs) {
            modelPageProcessor.addPageModel(clazz);
        }
        return modelPageProcessor;
    }

    public ModelPageProcessor addPageModel(Class clazz) {
        PageModelExtractor pageModelExtractor = PageModelExtractor.create(clazz);
        this.targetUrlPatterns.addAll(pageModelExtractor.getTargetUrlPatterns());
        this.targetUrlPatterns.addAll(pageModelExtractor.getHelpUrlPatterns());
        this.pageModelExtractorList.add(pageModelExtractor);
        return this;
    }

    private ModelPageProcessor(Site site) {
        this.site = site;
    }

    public void process(Page page) {
        for (PageModelExtractor pageModelExtractor : this.pageModelExtractorList) {
            this.extractLinks(page, pageModelExtractor.getHelpUrlRegionSelector(), pageModelExtractor.getHelpUrlPatterns());
            this.extractLinks(page, pageModelExtractor.getTargetUrlRegionSelector(), pageModelExtractor.getTargetUrlPatterns());
            Object process = pageModelExtractor.process(page);
            if (process == null || process instanceof List && ((List)process).size() == 0) {
                page.getResultItems().setSkip(true);
            }
            this.postProcessPageModel(pageModelExtractor.getClazz(), process);
            page.putField(pageModelExtractor.getClazz().getCanonicalName(), process);
        }
    }

    private void extractLinks(Page page, Selector urlRegionSelector, List<Pattern> urlPatterns) {
        List links = urlRegionSelector == null ? page.getHtml().links().all() : urlRegionSelector.selectList(page.getHtml().toString());
        for (String link : links) {
            for (Pattern targetUrlPattern : urlPatterns) {
                Matcher matcher = targetUrlPattern.matcher(link);
                if (!matcher.find()) continue;
                page.addTargetRequest(new Request(matcher.group(1)));
            }
        }
    }

    protected void postProcessPageModel(Class clazz, Object object) {
    }

    public Site getSite() {
        return this.site;
    }
}

