/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.model.AfterExtractor;
import us.codecraft.webmagic.model.Extractor;
import us.codecraft.webmagic.model.FieldExtractor;
import us.codecraft.webmagic.model.annotation.ComboExtract;
import us.codecraft.webmagic.model.annotation.ExtractBy;
import us.codecraft.webmagic.model.annotation.ExtractByUrl;
import us.codecraft.webmagic.model.annotation.HelpUrl;
import us.codecraft.webmagic.model.annotation.TargetUrl;
import us.codecraft.webmagic.selector.AndSelector;
import us.codecraft.webmagic.selector.OrSelector;
import us.codecraft.webmagic.selector.RegexSelector;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.XpathSelector;
import us.codecraft.webmagic.utils.ExtractorUtils;

class PageModelExtractor {
    private List<Pattern> targetUrlPatterns = new ArrayList<Pattern>();
    private Selector targetUrlRegionSelector;
    private List<Pattern> helpUrlPatterns = new ArrayList<Pattern>();
    private Selector helpUrlRegionSelector;
    private Class clazz;
    private List<FieldExtractor> fieldExtractors;
    private Extractor objectExtractor;

    PageModelExtractor() {
    }

    public static PageModelExtractor create(Class clazz) {
        PageModelExtractor pageModelExtractor = new PageModelExtractor();
        pageModelExtractor.init(clazz);
        return pageModelExtractor;
    }

    private void init(Class clazz) {
        this.clazz = clazz;
        this.initClassExtractors();
        this.fieldExtractors = new ArrayList<FieldExtractor>();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            FieldExtractor fieldExtractor = this.getAnnotationExtractBy(clazz, field);
            FieldExtractor fieldExtractorTmp = this.getAnnotationExtractCombo(clazz, field);
            if (fieldExtractor != null && fieldExtractorTmp != null) {
                throw new IllegalStateException("Only one of 'ExtractBy ComboExtract ExtractByUrl' can be added to a field!");
            }
            if (fieldExtractor == null && fieldExtractorTmp != null) {
                fieldExtractor = fieldExtractorTmp;
            }
            fieldExtractorTmp = this.getAnnotationExtractByUrl(clazz, field);
            if (fieldExtractor != null && fieldExtractorTmp != null) {
                throw new IllegalStateException("Only one of 'ExtractBy ComboExtract ExtractByUrl' can be added to a field!");
            }
            if (fieldExtractor == null && fieldExtractorTmp != null) {
                fieldExtractor = fieldExtractorTmp;
            }
            if (fieldExtractor == null) continue;
            if (!fieldExtractor.isMulti() && !String.class.isAssignableFrom(field.getType())) {
                throw new IllegalStateException("Field " + field.getName() + " must be string");
            }
            if (fieldExtractor.isMulti() && !List.class.isAssignableFrom(field.getType())) {
                throw new IllegalStateException("Field " + field.getName() + " must be list");
            }
            this.fieldExtractors.add(fieldExtractor);
        }
    }

    private FieldExtractor getAnnotationExtractByUrl(Class clazz, Field field) {
        FieldExtractor fieldExtractor = null;
        ExtractByUrl extractByUrl = field.getAnnotation(ExtractByUrl.class);
        if (extractByUrl != null) {
            String regexPattern = extractByUrl.value();
            if (regexPattern.trim().equals("")) {
                regexPattern = ".*";
            }
            fieldExtractor = new FieldExtractor(field, (Selector)new RegexSelector(regexPattern), Extractor.Source.Url, extractByUrl.notNull(), extractByUrl.multi());
            Method setterMethod = PageModelExtractor.getSetterMethod(clazz, field);
            if (setterMethod != null) {
                fieldExtractor.setSetterMethod(setterMethod);
            }
        }
        return fieldExtractor;
    }

    private FieldExtractor getAnnotationExtractCombo(Class clazz, Field field) {
        FieldExtractor fieldExtractor = null;
        ComboExtract comboExtract = field.getAnnotation(ComboExtract.class);
        if (comboExtract != null) {
            AndSelector selector;
            ExtractBy[] extractBies = comboExtract.value();
            switch (comboExtract.op()) {
                case And: {
                    selector = new AndSelector(ExtractorUtils.getSelectors(extractBies));
                    break;
                }
                case Or: {
                    selector = new OrSelector(ExtractorUtils.getSelectors(extractBies));
                    break;
                }
                default: {
                    selector = new AndSelector(ExtractorUtils.getSelectors(extractBies));
                }
            }
            fieldExtractor = new FieldExtractor(field, (Selector)selector, comboExtract.source() == ComboExtract.Source.RawHtml ? Extractor.Source.RawHtml : Extractor.Source.Html, comboExtract.notNull(), comboExtract.multi());
            Method setterMethod = PageModelExtractor.getSetterMethod(clazz, field);
            if (setterMethod != null) {
                fieldExtractor.setSetterMethod(setterMethod);
            }
        }
        return fieldExtractor;
    }

    private FieldExtractor getAnnotationExtractBy(Class clazz, Field field) {
        FieldExtractor fieldExtractor = null;
        ExtractBy extractBy = field.getAnnotation(ExtractBy.class);
        if (extractBy != null) {
            Selector selector = ExtractorUtils.getSelector(extractBy);
            fieldExtractor = new FieldExtractor(field, selector, extractBy.source() == ExtractBy.Source.RawHtml ? Extractor.Source.RawHtml : Extractor.Source.Html, extractBy.notNull(), extractBy.multi());
            Method setterMethod = PageModelExtractor.getSetterMethod(clazz, field);
            if (setterMethod != null) {
                fieldExtractor.setSetterMethod(setterMethod);
            }
        }
        return fieldExtractor;
    }

    public static Method getSetterMethod(Class clazz, Field field) {
        String name = "set" + StringUtils.capitalize((String)field.getName());
        try {
            Method declaredMethod = clazz.getDeclaredMethod(name, field.getType());
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void initClassExtractors() {
        String[] value;
        Annotation annotation = this.clazz.getAnnotation(TargetUrl.class);
        if (annotation == null) {
            this.targetUrlPatterns.add(Pattern.compile(".*"));
        } else {
            TargetUrl targetUrl = annotation;
            for (String s : value = targetUrl.value()) {
                this.targetUrlPatterns.add(Pattern.compile("(" + s.replace(".", "\\.").replace("*", "[^\"'#]*") + ")"));
            }
            if (!targetUrl.sourceRegion().equals("")) {
                this.targetUrlRegionSelector = new XpathSelector(targetUrl.sourceRegion());
            }
        }
        annotation = this.clazz.getAnnotation(HelpUrl.class);
        if (annotation != null) {
            HelpUrl helpUrl = (HelpUrl)annotation;
            for (String s : value = helpUrl.value()) {
                this.helpUrlPatterns.add(Pattern.compile("(" + s.replace(".", "\\.").replace("*", "[^\"'#]*") + ")"));
            }
            if (!helpUrl.sourceRegion().equals("")) {
                this.helpUrlRegionSelector = new XpathSelector(helpUrl.sourceRegion());
            }
        }
        if ((annotation = this.clazz.getAnnotation(ExtractBy.class)) != null) {
            ExtractBy extractBy = (ExtractBy)annotation;
            this.objectExtractor = new Extractor((Selector)new XpathSelector(extractBy.value()), Extractor.Source.Html, extractBy.notNull(), extractBy.multi());
        }
    }

    public Object process(Page page) {
        boolean matched = false;
        for (Pattern targetPattern : this.targetUrlPatterns) {
            if (!targetPattern.matcher(page.getUrl().toString()).matches()) continue;
            matched = true;
        }
        if (!matched) {
            return null;
        }
        if (this.objectExtractor == null) {
            return this.processSingle(page, null, true);
        }
        if (this.objectExtractor.multi) {
            ArrayList<Object> os = new ArrayList<Object>();
            List list = this.objectExtractor.getSelector().selectList(page.getHtml().toString());
            for (String s : list) {
                Object o = this.processSingle(page, s, false);
                if (o == null) continue;
                os.add(o);
            }
            return os;
        }
        String select = this.objectExtractor.getSelector().select(page.getHtml().toString());
        Object o = this.processSingle(page, select, false);
        return o;
    }

    private Object processSingle(Page page, String html, boolean isRaw) {
        Object o = null;
        try {
            o = this.clazz.newInstance();
            for (FieldExtractor fieldExtractor : this.fieldExtractors) {
                Object value;
                if (fieldExtractor.isMulti()) {
                    switch (fieldExtractor.getSource()) {
                        case RawHtml: {
                            value = page.getHtml().selectDocumentForList(fieldExtractor.getSelector());
                            break;
                        }
                        case Html: {
                            if (isRaw) {
                                value = page.getHtml().selectDocumentForList(fieldExtractor.getSelector());
                                break;
                            }
                            value = fieldExtractor.getSelector().selectList(html);
                            break;
                        }
                        case Url: {
                            value = fieldExtractor.getSelector().selectList(page.getUrl().toString());
                            break;
                        }
                        default: {
                            value = fieldExtractor.getSelector().selectList(html);
                        }
                    }
                    if ((value == null || value.size() == 0) && fieldExtractor.isNotNull()) {
                        return null;
                    }
                    this.setField(o, fieldExtractor, value);
                    continue;
                }
                switch (fieldExtractor.getSource()) {
                    case RawHtml: {
                        value = page.getHtml().selectDocument(fieldExtractor.getSelector());
                        break;
                    }
                    case Html: {
                        if (isRaw) {
                            value = page.getHtml().selectDocument(fieldExtractor.getSelector());
                            break;
                        }
                        value = fieldExtractor.getSelector().select(html);
                        break;
                    }
                    case Url: {
                        value = fieldExtractor.getSelector().select(page.getUrl().toString());
                        break;
                    }
                    default: {
                        value = fieldExtractor.getSelector().select(html);
                    }
                }
                if (value == null && fieldExtractor.isNotNull()) {
                    return null;
                }
                this.setField(o, fieldExtractor, value);
            }
            if (AfterExtractor.class.isAssignableFrom(this.clazz)) {
                ((AfterExtractor)o).afterProcess(page);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return o;
    }

    private void setField(Object o, FieldExtractor fieldExtractor, Object value) throws IllegalAccessException, InvocationTargetException {
        if (fieldExtractor.getSetterMethod() != null) {
            fieldExtractor.getSetterMethod().invoke(o, value);
        }
        fieldExtractor.getField().set(o, value);
    }

    Class getClazz() {
        return this.clazz;
    }

    List<Pattern> getTargetUrlPatterns() {
        return this.targetUrlPatterns;
    }

    List<Pattern> getHelpUrlPatterns() {
        return this.helpUrlPatterns;
    }

    Selector getTargetUrlRegionSelector() {
        return this.targetUrlRegionSelector;
    }

    Selector getHelpUrlRegionSelector() {
        return this.helpUrlRegionSelector;
    }
}

