/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.codecraft.webmagic.Request;

public abstract class RequestUtils {
    private static Pattern p4Range = Pattern.compile("\\[(\\d+)\\-(\\d+)\\]");

    public static List<Request> from(String exp) {
        int rangeTo;
        Matcher matcher = p4Range.matcher(exp);
        if (!matcher.find()) {
            return Collections.singletonList(new Request(exp));
        }
        int rangeFrom = Integer.parseInt(matcher.group(1));
        if (rangeFrom > (rangeTo = Integer.parseInt(matcher.group(2)))) {
            return Collections.emptyList();
        }
        ArrayList<Request> requests = new ArrayList<Request>(rangeTo - rangeFrom + 1);
        for (int i = rangeFrom; i <= rangeTo; ++i) {
            requests.add(new Request(matcher.replaceAll(String.valueOf(i))));
        }
        return requests;
    }
}

