/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.handler;

import java.util.ArrayList;
import java.util.List;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.handler.RequestMatcher;
import us.codecraft.webmagic.handler.SubPageProcessor;
import us.codecraft.webmagic.processor.PageProcessor;

public class CompositePageProcessor
implements PageProcessor {
    private Site site;
    private List<SubPageProcessor> subPageProcessors = new ArrayList<SubPageProcessor>();

    public CompositePageProcessor(Site site) {
        this.site = site;
    }

    public void process(Page page) {
        for (SubPageProcessor subPageProcessor : this.subPageProcessors) {
            RequestMatcher.MatchOther matchOtherProcessorProcessor;
            if (!subPageProcessor.match(page.getRequest()) || (matchOtherProcessorProcessor = subPageProcessor.processPage(page)) != null && matchOtherProcessorProcessor == RequestMatcher.MatchOther.YES) continue;
            return;
        }
    }

    public CompositePageProcessor setSite(Site site) {
        this.site = site;
        return this;
    }

    public CompositePageProcessor addSubPageProcessor(SubPageProcessor subPageProcessor) {
        this.subPageProcessors.add(subPageProcessor);
        return this;
    }

    public CompositePageProcessor setSubPageProcessors(SubPageProcessor ... subPageProcessors) {
        this.subPageProcessors = new ArrayList<SubPageProcessor>();
        for (SubPageProcessor subPageProcessor : subPageProcessors) {
            this.subPageProcessors.add(subPageProcessor);
        }
        return this;
    }

    public Site getSite() {
        return this.site;
    }
}

