/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import us.codecraft.webmagic.selector.AbstractSelectable;
import us.codecraft.webmagic.selector.BaseElementSelector;
import us.codecraft.webmagic.selector.CssSelector;
import us.codecraft.webmagic.selector.LinksSelector;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.Selectors;
import us.codecraft.webmagic.selector.SmartContentSelector;
import us.codecraft.webmagic.selector.XpathSelector;

public class HtmlNode
extends AbstractSelectable {
    private final List<Element> elements;

    public HtmlNode(List<Element> elements) {
        this.elements = elements;
    }

    public HtmlNode() {
        this.elements = null;
    }

    protected List<Element> getElements() {
        return this.elements;
    }

    @Override
    public Selectable smartContent() {
        SmartContentSelector smartContentSelector = Selectors.smartContent();
        return this.select(smartContentSelector, this.getSourceTexts());
    }

    @Override
    public Selectable links() {
        return this.selectElements(new LinksSelector());
    }

    @Override
    public Selectable xpath(String xpath) {
        XpathSelector xpathSelector = Selectors.xpath(xpath);
        return this.selectElements(xpathSelector);
    }

    @Override
    public Selectable selectList(Selector selector) {
        if (selector instanceof BaseElementSelector) {
            return this.selectElements((BaseElementSelector)selector);
        }
        return this.selectList(selector, this.getSourceTexts());
    }

    @Override
    public Selectable select(Selector selector) {
        return this.selectList(selector);
    }

    protected Selectable selectElements(BaseElementSelector elementSelector) {
        ListIterator<Element> elementIterator = this.getElements().listIterator();
        if (!elementSelector.hasAttribute()) {
            ArrayList<Element> resultElements = new ArrayList<Element>();
            while (elementIterator.hasNext()) {
                Element element = this.checkElementAndConvert(elementIterator);
                List<Element> selectElements = elementSelector.selectElements(element);
                resultElements.addAll(selectElements);
            }
            return new HtmlNode(resultElements);
        }
        ArrayList<String> resultStrings = new ArrayList<String>();
        while (elementIterator.hasNext()) {
            Element element = this.checkElementAndConvert(elementIterator);
            List<String> selectList = elementSelector.selectList(element);
            resultStrings.addAll(selectList);
        }
        return new PlainText(resultStrings);
    }

    private Element checkElementAndConvert(ListIterator<Element> elementIterator) {
        Element element = elementIterator.next();
        if (!(element instanceof Document)) {
            Document root = new Document(element.ownerDocument().baseUri());
            Element clone = element.clone();
            root.appendChild((Node)clone);
            elementIterator.set((Element)root);
            return root;
        }
        return element;
    }

    @Override
    public Selectable $(String selector) {
        CssSelector cssSelector = Selectors.$(selector);
        return this.selectElements(cssSelector);
    }

    @Override
    public Selectable $(String selector, String attrName) {
        CssSelector cssSelector = Selectors.$(selector, attrName);
        return this.selectElements(cssSelector);
    }

    @Override
    public List<Selectable> nodes() {
        ArrayList<Selectable> selectables = new ArrayList<Selectable>();
        for (Element element : this.getElements()) {
            ArrayList<Element> childElements = new ArrayList<Element>(1);
            childElements.add(element);
            selectables.add(new HtmlNode(childElements));
        }
        return selectables;
    }

    @Override
    protected List<String> getSourceTexts() {
        ArrayList<String> sourceTexts = new ArrayList<String>(this.getElements().size());
        for (Element element : this.getElements()) {
            sourceTexts.add(element.toString());
        }
        return sourceTexts;
    }
}

