/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.model;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class HttpRequestBody {
    private final byte[] body;
    private final String contentType;
    private final String encoding;

    public HttpRequestBody(byte[] body, String contentType, String encoding) {
        this.body = body;
        this.contentType = contentType;
        this.encoding = encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static HttpRequestBody json(String json, String encoding) throws UnsupportedEncodingException {
        return new HttpRequestBody(json.getBytes(encoding), "application/json", encoding);
    }

    public static HttpRequestBody xml(String xml, String encoding) throws UnsupportedEncodingException {
        return new HttpRequestBody(xml.getBytes(encoding), "text/xml", encoding);
    }

    public static HttpRequestBody custom(byte[] body, String contentType, String encoding) throws UnsupportedEncodingException {
        return new HttpRequestBody(body, contentType, encoding);
    }

    public static HttpRequestBody form(Map<String, Object> params, String encoding) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            nameValuePairs.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
        }
        return new HttpRequestBody(URLEncodedUtils.format(nameValuePairs, (String)encoding).getBytes(encoding), "application/x-www-form-urlencoded", encoding);
    }

    public byte[] getBody() {
        return this.body;
    }

    public static abstract class ContentType {
        public static final String JSON = "application/json";
        public static final String XML = "text/xml";
        public static final String FORM = "application/x-www-form-urlencoded";
        public static final String MULTIPART = "multipart/form-data";
    }
}

