/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.Request;

public class UrlUtils {
    private static Pattern patternForProtocal = Pattern.compile("[\\w]+://");
    private static final Pattern patternForCharset = Pattern.compile("charset\\s*=\\s*['\"]*([^\\s;'\"]*)");

    public static String canonicalizeUrl(String url, String refer) {
        try {
            URL base;
            try {
                base = new URL(refer);
            }
            catch (MalformedURLException e) {
                URL abs = new URL(refer);
                return abs.toExternalForm();
            }
            if (url.startsWith("?")) {
                url = base.getPath() + url;
            }
            URL abs = new URL(base, url);
            return UrlUtils.encodeIllegalCharacterInUrl(abs.toExternalForm());
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static String encodeIllegalCharacterInUrl(String url) {
        return url.replace(" ", "%20");
    }

    public static String getHost(String url) {
        String host = url;
        int i = StringUtils.ordinalIndexOf((CharSequence)url, (CharSequence)"/", (int)3);
        if (i > 0) {
            host = StringUtils.substring((String)url, (int)0, (int)i);
        }
        return host;
    }

    public static String removeProtocol(String url) {
        return patternForProtocal.matcher(url).replaceAll("");
    }

    public static String getDomain(String url) {
        String domain = UrlUtils.removeProtocol(url);
        int i = StringUtils.indexOf((CharSequence)domain, (CharSequence)"/", (int)1);
        if (i > 0) {
            domain = StringUtils.substring((String)domain, (int)0, (int)i);
        }
        return UrlUtils.removePort(domain);
    }

    public static String removePort(String domain) {
        int portIndex = domain.indexOf(":");
        if (portIndex != -1) {
            return domain.substring(0, portIndex);
        }
        return domain;
    }

    public static List<Request> convertToRequests(Collection<String> urls) {
        ArrayList<Request> requestList = new ArrayList<Request>(urls.size());
        for (String url : urls) {
            requestList.add(new Request(url));
        }
        return requestList;
    }

    public static List<String> convertToUrls(Collection<Request> requests) {
        ArrayList<String> urlList = new ArrayList<String>(requests.size());
        for (Request request : requests) {
            urlList.add(request.getUrl());
        }
        return urlList;
    }

    public static String getCharset(String contentType) {
        String charset;
        Matcher matcher = patternForCharset.matcher(contentType);
        if (matcher.find() && Charset.isSupported(charset = matcher.group(1))) {
            return charset;
        }
        return null;
    }
}

