/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import us.codecraft.webmagic.selector.BaseElementSelector;

public class CssSelector
extends BaseElementSelector {
    private String selectorText;
    private String attrName;

    public CssSelector(String selectorText) {
        this.selectorText = selectorText;
    }

    public CssSelector(String selectorText, String attrName) {
        this.selectorText = selectorText;
        this.attrName = attrName;
    }

    private String getValue(Element element) {
        if (this.attrName == null) {
            return element.outerHtml();
        }
        if ("innerHtml".equalsIgnoreCase(this.attrName)) {
            return element.html();
        }
        if ("text".equalsIgnoreCase(this.attrName)) {
            return this.getText(element);
        }
        if ("allText".equalsIgnoreCase(this.attrName)) {
            return element.text();
        }
        return element.attr(this.attrName);
    }

    protected String getText(Element element) {
        StringBuilder accum = new StringBuilder();
        for (Node node : element.childNodes()) {
            if (!(node instanceof TextNode)) continue;
            TextNode textNode = (TextNode)node;
            accum.append(textNode.text());
        }
        return accum.toString();
    }

    @Override
    public String select(Element element) {
        List<Element> elements = this.selectElements(element);
        if (CollectionUtils.isEmpty(elements)) {
            return null;
        }
        return this.getValue(elements.get(0));
    }

    @Override
    public List<String> selectList(Element doc) {
        ArrayList<String> strings = new ArrayList<String>();
        List<Element> elements = this.selectElements(doc);
        if (CollectionUtils.isNotEmpty(elements)) {
            for (Element element : elements) {
                String value = this.getValue(element);
                if (value == null) continue;
                strings.add(value);
            }
        }
        return strings;
    }

    @Override
    public Element selectElement(Element element) {
        Elements elements = element.select(this.selectorText);
        if (CollectionUtils.isNotEmpty((Collection)elements)) {
            return elements.get(0);
        }
        return null;
    }

    @Override
    public List<Element> selectElements(Element element) {
        return element.select(this.selectorText);
    }

    @Override
    public boolean hasAttribute() {
        return this.attrName != null;
    }
}

