/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.List;
import us.codecraft.webmagic.selector.Selector;

public class AndSelector
implements Selector {
    private List<Selector> selectors = new ArrayList<Selector>();

    public AndSelector(Selector ... selectors) {
        for (Selector selector : selectors) {
            this.selectors.add(selector);
        }
    }

    public AndSelector(List<Selector> selectors) {
        this.selectors = selectors;
    }

    @Override
    public String select(String text) {
        for (Selector selector : this.selectors) {
            if (text == null) {
                return null;
            }
            text = selector.select(text);
        }
        return text;
    }

    @Override
    public List<String> selectList(String text) {
        List<String> results = new ArrayList<String>();
        boolean first = true;
        for (Selector selector : this.selectors) {
            if (first) {
                results = selector.selectList(text);
                first = false;
                continue;
            }
            ArrayList<String> resultsTemp = new ArrayList<String>();
            for (String result : results) {
                resultsTemp.addAll(selector.selectList(result));
            }
            results = resultsTemp;
            if (results != null && results.size() != 0) continue;
            return results;
        }
        return results;
    }
}

