/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import us.codecraft.webmagic.selector.BaseElementSelector;

public class CssSelector
extends BaseElementSelector {
    private String selectorText;
    private String attrName;

    public CssSelector(String selectorText) {
        this.selectorText = selectorText;
    }

    public CssSelector(String selectorText, String attrName) {
        this.selectorText = selectorText;
        this.attrName = attrName;
    }

    private String getValue(Element element) {
        if (this.attrName == null) {
            return element.outerHtml();
        }
        if ("innerHtml".equalsIgnoreCase(this.attrName)) {
            return element.html();
        }
        return element.attr(this.attrName);
    }

    @Override
    public String select(Element element) {
        Elements elements = element.select(this.selectorText);
        if (CollectionUtils.isEmpty((Collection)elements)) {
            return null;
        }
        return this.getValue(elements.get(0));
    }

    @Override
    public List<String> selectList(Element doc) {
        ArrayList<String> strings = new ArrayList<String>();
        Elements elements = doc.select(this.selectorText);
        if (CollectionUtils.isNotEmpty((Collection)elements)) {
            for (Element element : elements) {
                String value = this.getValue(element);
                if (value == null) continue;
                strings.add(value);
            }
        }
        return strings;
    }
}

