/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.utils.Experimental;

@Experimental
public class SmartContentSelector
implements Selector {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final double parentWeight = 0.7;

    @Override
    public String select(String text) {
        HtmlCleaner htmlCleaner = new HtmlCleaner();
        TagNode tagNode = htmlCleaner.clean(text);
        if (tagNode == null) {
            return null;
        }
        TagNode[] nodes = tagNode.getElementsByName("p", true);
        TagNode[] pres = tagNode.getElementsByName("pre", true);
        HashMap<TagNode, Double> pDensityCountMap = new HashMap<TagNode, Double>();
        this.countPdensity(nodes, pDensityCountMap);
        this.countPdensity(pres, pDensityCountMap);
        for (TagNode pre : pres) {
            this.addCounter(pre, pDensityCountMap, 2.0);
        }
        ArrayList sortList = new ArrayList();
        if (pDensityCountMap.size() == 0) {
            return null;
        }
        for (Map.Entry entry : pDensityCountMap.entrySet()) {
            sortList.add(entry);
        }
        Collections.sort(sortList, new Comparator<Map.Entry<TagNode, Double>>(){

            @Override
            public int compare(Map.Entry<TagNode, Double> o1, Map.Entry<TagNode, Double> o2) {
                Double d1 = o1.getValue();
                Double d2 = o2.getValue();
                return -d1.compareTo(d2);
            }
        });
        TagNode contentNode = (TagNode)((Map.Entry)sortList.get(0)).getKey();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("p\t" + contentNode.getName() + "#" + contentNode.getAttributeByName("id") + "@" + contentNode.getAttributeByName("class")));
        }
        return htmlCleaner.getInnerHtml(contentNode);
    }

    private void addCounter(TagNode node, Map<TagNode, Double> countMap, double delta) {
        Double counter = countMap.get(node);
        if (counter == null) {
            countMap.put(node, delta);
        } else {
            countMap.put(node, counter + delta);
        }
    }

    private void countPdensity(TagNode[] nodes, Map<TagNode, Double> pDensityCountMap) {
        for (TagNode node : nodes) {
            if (node == null) continue;
            TagNode parent = node.getParent();
            double pDensity = 1.0;
            while (parent != null) {
                this.addCounter(parent, pDensityCountMap, pDensity);
                parent = parent.getParent();
                pDensity *= 0.7;
            }
        }
    }

    private TagNode findLowestCommonParent(List<TagNode> tagNodes, int maxMargin, Map<TagNode, AtomicInteger> countMap) {
        TagNode contentNode = tagNodes.get(0);
        return contentNode;
    }

    @Override
    public List<String> selectList(String text) {
        throw new UnsupportedOperationException();
    }
}

