/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UrlUtils {
    private static Pattern relativePathPattern = Pattern.compile("^([\\.]+)/");
    private static Pattern patternForProtocal = Pattern.compile("[\\w]+://");
    private static Pattern patternForHref = Pattern.compile("(<a[^<>]*href=)[\"']{0,1}([^\"'<>\\s]*)[\"']{0,1}", 2);
    private static final Pattern patternForCharset = Pattern.compile("charset=([^\\s;]*)");

    public static String canonicalizeUrl(String url, String refer) {
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)refer)) {
            return url;
        }
        if (url.startsWith("http") || url.startsWith("ftp") || url.startsWith("mailto") || url.startsWith("javascript:")) {
            return url;
        }
        if (StringUtils.startsWith((CharSequence)url, (CharSequence)"/")) {
            String host = UrlUtils.getHost(refer);
            return host + url;
        }
        if (!StringUtils.startsWith((CharSequence)url, (CharSequence)".")) {
            refer = UrlUtils.reversePath(refer, 1);
            return refer + "/" + url;
        }
        Matcher matcher = relativePathPattern.matcher(url);
        if (matcher.find()) {
            int reverseDepth = matcher.group(1).length();
            refer = UrlUtils.reversePath(refer, reverseDepth);
            String substring = StringUtils.substring((String)url, (int)matcher.end());
            return refer + "/" + substring;
        }
        refer = UrlUtils.reversePath(refer, 1);
        return refer + "/" + url;
    }

    public static String reversePath(String url, int depth) {
        int i = StringUtils.lastOrdinalIndexOf((CharSequence)url, (CharSequence)"/", (int)depth);
        url = i < 10 ? UrlUtils.getHost(url) : StringUtils.substring((String)url, (int)0, (int)i);
        return url;
    }

    public static String getHost(String url) {
        String host = url;
        int i = StringUtils.ordinalIndexOf((CharSequence)url, (CharSequence)"/", (int)3);
        if (i > 0) {
            host = StringUtils.substring((String)url, (int)0, (int)i);
        }
        return host;
    }

    public static String removeProtocol(String url) {
        return patternForProtocal.matcher(url).replaceAll("");
    }

    public static String getDomain(String url) {
        String domain = UrlUtils.removeProtocol(url);
        int i = StringUtils.indexOf((CharSequence)domain, (CharSequence)"/", (int)1);
        if (i > 0) {
            domain = StringUtils.substring((String)domain, (int)0, (int)i);
        }
        return domain;
    }

    public static String fixAllRelativeHrefs(String html, String url) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = patternForHref.matcher(html);
        int lastEnd = 0;
        while (matcher.find()) {
            stringBuilder.append(StringUtils.substring((String)html, (int)lastEnd, (int)matcher.start()));
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("\"").append(UrlUtils.canonicalizeUrl(matcher.group(2), url)).append("\"");
            lastEnd = matcher.end();
        }
        stringBuilder.append(StringUtils.substring((String)html, (int)lastEnd));
        return stringBuilder.toString();
    }

    public static String getCharset(String contentType) {
        Matcher matcher = patternForCharset.matcher(contentType);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

