/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import us.codecraft.webmagic.selector.RegexSelector;
import us.codecraft.webmagic.selector.ReplaceSelector;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.SelectorFactory;

public class PlainText
implements Selectable {
    protected List<String> strings;

    public PlainText(List<String> strings) {
        this.strings = strings;
    }

    public PlainText(String text) {
        ArrayList<String> results = new ArrayList<String>();
        results.add(text);
        this.strings = results;
    }

    public static PlainText create(String text) {
        return new PlainText(text);
    }

    @Override
    public Selectable xpath(String xpath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Selectable $(String selector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Selectable $(String selector, String attrName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Selectable smartContent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Selectable links() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Selectable regex(String regex) {
        RegexSelector regexSelector = SelectorFactory.getInstatnce().newRegexSelector(regex);
        return this.selectList(regexSelector, this.strings);
    }

    @Override
    public Selectable regex(String regex, int group) {
        RegexSelector regexSelector = SelectorFactory.getInstatnce().newRegexSelector(regex, group);
        return this.selectList(regexSelector, this.strings);
    }

    protected Selectable select(Selector selector, List<String> strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            String result = selector.select(string);
            if (result == null) continue;
            results.add(result);
        }
        return new PlainText(results);
    }

    protected Selectable selectList(Selector selector, List<String> strings) {
        ArrayList<String> results = new ArrayList<String>();
        for (String string : strings) {
            List<String> result = selector.selectList(string);
            results.addAll(result);
        }
        return new PlainText(results);
    }

    @Override
    public Selectable replace(String regex, String replacement) {
        ReplaceSelector replaceSelector = SelectorFactory.getInstatnce().newReplaceSelector(regex, replacement);
        return this.select(replaceSelector, this.strings);
    }

    @Override
    public List<String> all() {
        return this.strings;
    }

    @Override
    public String toString() {
        if (CollectionUtils.isNotEmpty(this.all())) {
            return this.all().get(0);
        }
        return null;
    }
}

