/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import us.codecraft.webmagic.selector.Selector;

public class CssSelector
implements Selector {
    private String selectorText;
    private String attrName;

    public CssSelector(String selectorText) {
        this.selectorText = selectorText;
    }

    public CssSelector(String selectorText, String attrName) {
        this.selectorText = selectorText;
        this.attrName = attrName;
    }

    @Override
    public String select(String text) {
        Document doc = Jsoup.parse((String)text);
        Elements elements = doc.select(this.selectorText);
        if (CollectionUtils.isEmpty((Collection)elements)) {
            return null;
        }
        return this.getValue(elements.get(0));
    }

    private String getValue(Element element) {
        if (this.attrName == null) {
            return element.outerHtml();
        }
        if ("innerHtml".equalsIgnoreCase(this.attrName)) {
            return element.html();
        }
        return element.attr(this.attrName);
    }

    @Override
    public List<String> selectList(String text) {
        ArrayList<String> strings = new ArrayList<String>();
        Document doc = Jsoup.parse((String)text);
        Elements elements = doc.select(this.selectorText);
        if (CollectionUtils.isNotEmpty((Collection)elements)) {
            for (Element element : elements) {
                String value = this.getValue(element);
                if (value == null) continue;
                strings.add(value);
            }
        }
        return strings;
    }
}

