/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader;

import java.util.Map;
import org.apache.http.HttpVersion;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParamBean;
import us.codecraft.webmagic.Site;

public class HttpClientPool {
    public static volatile HttpClientPool INSTANCE;
    private int poolSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClientPool getInstance(int poolSize) {
        if (INSTANCE != null) return INSTANCE;
        Class<HttpClientPool> clazz = HttpClientPool.class;
        synchronized (HttpClientPool.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new HttpClientPool(poolSize);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private HttpClientPool(int poolSize) {
        this.poolSize = poolSize;
    }

    public HttpClient getClient(Site site) {
        return this.generateClient(site);
    }

    private HttpClient generateClient(Site site) {
        BasicHttpParams params = new BasicHttpParams();
        if (site != null && site.getUserAgent() != null) {
            params.setParameter("http.useragent", (Object)site.getUserAgent());
        }
        params.setIntParameter("http.socket.timeout", 1000);
        params.setIntParameter("http.connection.timeout", 2000);
        HttpProtocolParamBean paramsBean = new HttpProtocolParamBean((HttpParams)params);
        paramsBean.setVersion(HttpVersion.HTTP_1_1);
        if (site != null && site.getCharset() != null) {
            paramsBean.setContentCharset(site.getCharset());
        }
        paramsBean.setUseExpectContinue(false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(this.poolSize);
        connectionManager.setDefaultMaxPerRoute(100);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)params);
        if (site != null) {
            this.generateCookie(httpClient, site);
        }
        httpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"best-match");
        return httpClient;
    }

    private void generateCookie(DefaultHttpClient httpClient, Site site) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        if (site.getCookies() != null) {
            for (Map.Entry<String, String> cookieEntry : site.getCookies().entrySet()) {
                BasicClientCookie cookie = new BasicClientCookie(cookieEntry.getKey(), cookieEntry.getValue());
                cookie.setDomain(site.getDomain());
                cookieStore.addCookie((Cookie)cookie);
            }
        }
        httpClient.setCookieStore((CookieStore)cookieStore);
    }
}

