/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.timers;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.UniformRandomTimer;
import org.apache.jmeter.timers.gui.UniformRandomTimerGui;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.timers.DslTimer;

public class DslUniformRandomTimer
extends BaseTestElement
implements DslTimer {
    private final long minimumMillis;
    private final long maximumMillis;

    public DslUniformRandomTimer(long minimumMillis, long maximumMillis) {
        super("Uniform Random Timer", UniformRandomTimerGui.class);
        this.minimumMillis = minimumMillis;
        this.maximumMillis = maximumMillis;
    }

    @Override
    protected TestElement buildTestElement() {
        UniformRandomTimer urt = new UniformRandomTimer();
        urt.setRange((double)(this.maximumMillis - this.minimumMillis));
        urt.setDelay(String.valueOf(this.minimumMillis));
        return urt;
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<UniformRandomTimer> {
        public CodeBuilder(List<Method> builderMethods) {
            super(UniformRandomTimer.class, builderMethods);
        }

        @Override
        protected MethodCall buildMethodCall(UniformRandomTimer testElement, MethodCallContext context) {
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElement);
            MethodParam delay = paramBuilder.longParam("ConstantTimer.delay");
            MethodParam range = paramBuilder.doubleParam("RandomTimer.range");
            if (!(delay instanceof MethodParam.LongParam) || !(range instanceof MethodParam.DoubleParam)) {
                throw new UnsupportedOperationException("Using JMeter expressions in timer properties is still not supported. Request it in the GitHub repository as an issue and we will add support for it.");
            }
            return this.buildMethodCall(delay, new MethodParam.LongParam((Long)((MethodParam.LongParam)delay).getValue() + Math.round((Double)((MethodParam.DoubleParam)range).getValue())));
        }
    }
}

