/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.threadgroups;

import java.awt.Component;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kg.apc.jmeter.threads.UltimateThreadGroup;
import kg.apc.jmeter.threads.UltimateThreadGroupGui;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;
import us.abstracta.jmeter.javadsl.core.threadgroups.defaultthreadgroup.SimpleThreadGroupHelper;
import us.abstracta.jmeter.javadsl.core.threadgroups.defaultthreadgroup.Stage;
import us.abstracta.jmeter.javadsl.core.threadgroups.defaultthreadgroup.UltimateThreadGroupHelper;
import us.abstracta.jmeter.javadsl.core.util.SingleSeriesTimelinePanel;

public class DslDefaultThreadGroup
extends BaseThreadGroup<DslDefaultThreadGroup> {
    private static final Integer ZERO = 0;
    private final List<Stage> stages = new ArrayList<Stage>();

    public DslDefaultThreadGroup(String name, int threads, int iterations, List<BaseThreadGroup.ThreadGroupChild> children) {
        this(name, children);
        this.checkThreadCount(threads);
        if (iterations <= 0) {
            throw new IllegalArgumentException("Iterations must be >=1");
        }
        this.stages.add(new Stage(threads, Duration.ZERO, null));
        this.stages.add(new Stage(threads, null, iterations));
    }

    private DslDefaultThreadGroup(String name, List<BaseThreadGroup.ThreadGroupChild> children) {
        super(name != null ? name : "Thread Group", (Class<? extends JMeterGUIComponent>)ThreadGroupGui.class, children);
    }

    public DslDefaultThreadGroup(String name, int threads, Duration duration, List<BaseThreadGroup.ThreadGroupChild> children) {
        this(name, children);
        this.checkThreadCount(threads);
        this.stages.add(new Stage(threads, Duration.ZERO, null));
        this.stages.add(new Stage(threads, duration, null));
    }

    public DslDefaultThreadGroup(String name) {
        this(name, Collections.emptyList());
    }

    private void checkThreadCount(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Threads count must be >=1");
        }
    }

    public DslDefaultThreadGroup rampTo(int threadCount, Duration duration) {
        if (threadCount < 0) {
            throw new IllegalArgumentException("Thread count must be >=0");
        }
        this.checkRampNotAfterIterations();
        this.addStage(new Stage(threadCount, duration, null));
        return this;
    }

    public DslDefaultThreadGroup rampTo(String threadCount, String duration) {
        this.checkRampNotAfterIterations();
        this.addStage(new Stage(threadCount, duration, null));
        return this;
    }

    private void checkRampNotAfterIterations() {
        if (this.isLastStageHoldingForIterations()) {
            throw new IllegalStateException("Ramping up/down after holding for iterations is not supported. If you used constructor with iterations, consider using threadGroup().rampTo(X, Y).holdForIterations(Z) instead");
        }
    }

    private boolean isLastStageHoldingForIterations() {
        return !this.stages.isEmpty() && this.getLastStage().duration() == null;
    }

    private Stage getLastStage() {
        return this.stages.get(this.stages.size() - 1);
    }

    private void addStage(Stage stage) {
        this.stages.add(stage);
        if (!this.isSimpleThreadGroup() && this.stages.stream().anyMatch(s -> !s.isFixedStage())) {
            this.stages.remove(this.stages.size() - 1);
            throw new UnsupportedOperationException("The DSL does not yet support configuring multiple thread ramps with ramp or hold parameters using jmeter expressions. If you need this please create an issue in Github repository.");
        }
    }

    private boolean isSimpleThreadGroup() {
        return this.stages.size() <= 1 || this.stages.size() == 2 && (ZERO.equals(this.stages.get(0).threadCount()) || this.stages.get(0).threadCount().equals(this.stages.get(1).threadCount())) || this.stages.size() == 3 && ZERO.equals(this.stages.get(0).threadCount()) && this.stages.get(1).threadCount().equals(this.stages.get(2).threadCount());
    }

    public DslDefaultThreadGroup holdFor(Duration duration) {
        this.checkHoldNotAfterIterations();
        this.addStage(new Stage(this.getPrevThreadsCount(), duration, null));
        return this;
    }

    public DslDefaultThreadGroup holdFor(String duration) {
        Object threadsCount = this.getPrevThreadsCount();
        this.checkHoldNotAfterIterations();
        this.addStage(new Stage(threadsCount, duration, null));
        return this;
    }

    private void checkHoldNotAfterIterations() {
        if (this.isLastStageHoldingForIterations()) {
            throw new IllegalStateException("Holding for duration after holding for iterations is not supported.");
        }
    }

    private Object getPrevThreadsCount() {
        return this.stages.isEmpty() ? Integer.valueOf(0) : this.getLastStage().threadCount();
    }

    public DslDefaultThreadGroup holdIterating(int iterations) {
        if (iterations < 0) {
            throw new IllegalArgumentException("Iterations must be >=0");
        }
        this.checkIterationsPreConditions();
        this.addStage(new Stage(this.getLastStage().threadCount(), null, iterations));
        return this;
    }

    public DslDefaultThreadGroup holdIterating(String iterations) {
        this.checkIterationsPreConditions();
        this.addStage(new Stage(this.getLastStage().threadCount(), null, iterations));
        return this;
    }

    private void checkIterationsPreConditions() {
        if (!(this.stages.size() == 1 && !ZERO.equals(this.stages.get(0).threadCount()) || this.stages.size() == 2 && ZERO.equals(this.stages.get(0).threadCount()) && !ZERO.equals(this.stages.get(1).threadCount()))) {
            throw new IllegalStateException("Holding for iterations is only supported after initial hold and ramp, or ramp.");
        }
        if (ZERO.equals(this.getLastStage().threadCount())) {
            throw new IllegalStateException("Can't hold for iterations with no threads.");
        }
    }

    public DslDefaultThreadGroup rampToAndHold(int threads, Duration rampDuration, Duration holdDuration) {
        return this.rampTo(threads, rampDuration).holdFor(holdDuration);
    }

    public DslDefaultThreadGroup rampToAndHold(String threads, String rampDuration, String holdDuration) {
        return this.rampTo(threads, rampDuration).holdFor(holdDuration);
    }

    @Override
    public DslDefaultThreadGroup children(BaseThreadGroup.ThreadGroupChild ... children) {
        return (DslDefaultThreadGroup)super.children(children);
    }

    @Override
    public AbstractThreadGroup buildThreadGroup() {
        if (this.isSimpleThreadGroup()) {
            return new SimpleThreadGroupHelper(this.stages).buildThreadGroup();
        }
        this.guiClass = UltimateThreadGroupGui.class;
        return new UltimateThreadGroupHelper(this.stages).buildThreadGroup();
    }

    @Deprecated
    public void showThreadsTimeline() {
        this.showTimeline();
    }

    public void showTimeline() {
        if (this.stages.stream().anyMatch(s -> !s.isFixedStage())) {
            throw new IllegalStateException("Can't display timeline when some JMeter expression is used in any ramp or hold.");
        }
        SingleSeriesTimelinePanel chart = new SingleSeriesTimelinePanel("Threads");
        chart.add(0L, 0.0);
        this.stages.forEach(s -> chart.add(((Duration)s.duration()).toMillis(), ((Integer)s.threadCount()).intValue()));
        this.showAndWaitFrameWith((Component)((Object)chart), this.name + " threads timeline", 800, 300);
    }

    public static class CodeBuilder
    extends MethodCallBuilder {
        public CodeBuilder(List<Method> builderMethods) {
            super(builderMethods);
        }

        @Override
        public boolean matches(MethodCallContext context) {
            TestElement testElement = context.getTestElement();
            return testElement.getClass() == ThreadGroup.class || testElement.getClass() == UltimateThreadGroup.class;
        }

        @Override
        protected MethodCall buildMethodCall(MethodCallContext context) {
            TestElement testElement = context.getTestElement();
            MethodCall ret = testElement.getClass() == ThreadGroup.class ? new SimpleThreadGroupHelper.CodeBuilder(this.builderMethods).buildMethodCall(context) : new UltimateThreadGroupHelper.CodeBuilder(this.builderMethods).buildMethodCall(context);
            ret.chain("sampleErrorAction", BaseThreadGroup.SampleErrorActionMethodParam.from(testElement));
            return ret;
        }
    }
}

