/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.testelements;

import java.util.function.Consumer;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;

public abstract class DslScopedTestElement<T>
extends BaseTestElement {
    private Scope scope = Scope.MAIN_SAMPLE;
    private String scopeVariable;

    protected DslScopedTestElement(String name, Class<? extends JMeterGUIComponent> guiClass) {
        super(name, guiClass);
    }

    public T scope(Scope scope) {
        this.scope = scope;
        return (T)this;
    }

    public T scopeVariable(String scopeVariable) {
        this.scopeVariable = scopeVariable;
        return (T)this;
    }

    protected void setScopeTo(AbstractScopedTestElement testElement) {
        this.scope.applyTo(testElement);
        if (this.scopeVariable != null) {
            testElement.setScopeVariable(this.scopeVariable);
        }
    }

    protected static class ScopeMethodParam
    extends MethodParam.FixedParam<Scope> {
        private ScopeMethodParam(String expression, Scope defaultValue) {
            super(Scope.class, expression, Scope::fromPropertyValue, defaultValue);
        }

        public static MethodParam from(TestElement testElement) {
            return new TestElementParamBuilder(testElement).buildParam("Sample.scope", ScopeMethodParam::new, Scope.MAIN_SAMPLE);
        }

        @Override
        public String buildCode(String indent) {
            return Scope.class.getSimpleName() + "." + ((Scope)((Object)this.value)).name();
        }
    }

    public static enum Scope {
        ALL_SAMPLES(AbstractScopedTestElement::setScopeAll),
        MAIN_SAMPLE(AbstractScopedTestElement::setScopeParent),
        SUB_SAMPLES(AbstractScopedTestElement::setScopeChildren);

        private final Consumer<AbstractScopedTestElement> applier;

        private Scope(Consumer<AbstractScopedTestElement> applier) {
            this.applier = applier;
        }

        private void applyTo(AbstractScopedTestElement re) {
            this.applier.accept(re);
        }

        public static Scope fromPropertyValue(String propertyValue) {
            if ("all".equals(propertyValue)) {
                return ALL_SAMPLES;
            }
            if ("children".equals(propertyValue)) {
                return SUB_SAMPLES;
            }
            return null;
        }
    }
}

