/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.postprocessors;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.extractor.gui.RegexExtractorGui;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.postprocessors.DslVariableExtractor;
import us.abstracta.jmeter.javadsl.core.testelements.DslScopedTestElement;

public class DslRegexExtractor
extends DslVariableExtractor<DslRegexExtractor> {
    private final String regex;
    private String template = "$1$";
    private TargetField fieldToCheck = TargetField.RESPONSE_BODY;

    public DslRegexExtractor(String varName, String regex) {
        super("Regular Expression Extractor", RegexExtractorGui.class, varName);
        this.regex = regex;
    }

    public DslRegexExtractor matchNumber(int matchNumber) {
        this.matchNumber = matchNumber;
        return this;
    }

    public DslRegexExtractor template(String template) {
        this.template = template;
        return this;
    }

    public DslRegexExtractor defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DslRegexExtractor fieldToCheck(TargetField fieldToCheck) {
        this.fieldToCheck = fieldToCheck;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        RegexExtractor ret = new RegexExtractor();
        this.setScopeTo((AbstractScopedTestElement)ret);
        ret.setUseField(this.fieldToCheck.propertyValue);
        ret.setRefName(this.varName);
        ret.setRegex(this.regex);
        ret.setMatchNumber(this.matchNumber);
        ret.setTemplate(this.template);
        if (this.defaultValue != null) {
            if (this.defaultValue.isEmpty()) {
                ret.setDefaultEmptyValue(true);
            } else {
                ret.setDefaultValue(this.defaultValue);
            }
        }
        return ret;
    }

    protected static class TargetFieldMethodParam
    extends MethodParam.FixedParam<TargetField> {
        private TargetFieldMethodParam(String expression, TargetField defaultValue) {
            super(TargetField.class, expression, TargetField::fromPropertyValue, defaultValue);
        }

        public static MethodParam from(TestElement testElement) {
            return new TestElementParamBuilder(testElement).buildParam("RegexExtractor.useHeaders", TargetFieldMethodParam::new, TargetField.RESPONSE_BODY);
        }

        @Override
        public String buildCode(String indent) {
            return TargetField.class.getSimpleName() + "." + ((TargetField)((Object)this.value)).name();
        }
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<RegexExtractor> {
        public CodeBuilder(List<Method> builderMethods) {
            super(RegexExtractor.class, builderMethods);
        }

        @Override
        protected MethodCall buildMethodCall(RegexExtractor testElement, MethodCallContext context) {
            TestElementParamBuilder regexParamBuilder = new TestElementParamBuilder((TestElement)testElement, "RegexExtractor");
            MethodCall ret = this.buildMethodCall(regexParamBuilder.stringParam("refname"), regexParamBuilder.stringParam("regex"));
            MethodParam scopeVar = new TestElementParamBuilder((TestElement)testElement).stringParam("Scope.variable");
            if (scopeVar.isDefault()) {
                ret.chain("scope", DslScopedTestElement.ScopeMethodParam.from((TestElement)testElement));
            } else {
                ret.chain("scopeVariable", scopeVar);
            }
            ret.chain("fieldToCheck", TargetFieldMethodParam.from((TestElement)testElement));
            ret.chain("matchNumber", regexParamBuilder.intParam("match_number", 1));
            ret.chain("template", regexParamBuilder.stringParam("template", "$1$"));
            ret.chain("defaultValue", this.buildDefaultParam(regexParamBuilder));
            return ret;
        }

        private MethodParam buildDefaultParam(TestElementParamBuilder regexParamBuilder) {
            MethodParam sourceDefaultParam;
            MethodParam param = regexParamBuilder.boolParam("default_empty_value", false);
            MethodParam defaultParam = !param.isDefault() ? new MethodParam.StringParam("") : ((sourceDefaultParam = regexParamBuilder.stringParam("default")).isDefault() ? new MethodParam.StringParam(null) : sourceDefaultParam);
            return defaultParam;
        }
    }

    public static enum TargetField {
        RESPONSE_BODY("false"),
        RESPONSE_BODY_UNESCAPED("unescaped"),
        RESPONSE_BODY_AS_DOCUMENT("as_document"),
        RESPONSE_HEADERS("true"),
        REQUEST_HEADERS("request_headers"),
        REQUEST_URL("URL"),
        RESPONSE_CODE("code"),
        RESPONSE_MESSAGE("message");

        private static final Map<String, TargetField> FIELDS_BY_PROPERTY_VALUE;
        private final String propertyValue;

        private TargetField(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public static TargetField fromPropertyValue(String propertyValue) {
            if (propertyValue.isEmpty()) {
                return null;
            }
            TargetField ret = FIELDS_BY_PROPERTY_VALUE.get(propertyValue);
            if (ret == null) {
                throw new IllegalArgumentException("Unknown " + TargetField.class.getSimpleName() + " property value: " + propertyValue);
            }
            return ret;
        }

        static {
            FIELDS_BY_PROPERTY_VALUE = Arrays.stream(TargetField.values()).collect(Collectors.toMap(v -> v.propertyValue, v -> v));
        }
    }
}

