/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.controllers;

import com.blazemeter.jmeter.control.WeightedSwitchController;
import com.blazemeter.jmeter.control.WeightedSwitchControllerGui;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.controllers.BaseController;
import us.abstracta.jmeter.javadsl.core.controllers.DslController;
import us.abstracta.jmeter.javadsl.core.samplers.DslSampler;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;

public class DslWeightedSwitchController
extends BaseController {
    public static final long DEFAULT_WEIGHT = 100L;

    public DslWeightedSwitchController() {
        super("Weighted Switch Controller", (Class<? extends JMeterGUIComponent>)WeightedSwitchControllerGui.class, (List<BaseThreadGroup.ThreadGroupChild>)new ArrayList<BaseThreadGroup.ThreadGroupChild>());
    }

    public DslWeightedSwitchController child(long weight, DslController child) {
        return this.addWeightedChild(weight, child);
    }

    public DslWeightedSwitchController child(long weight, DslSampler child) {
        return this.addWeightedChild(weight, child);
    }

    private DslWeightedSwitchController addWeightedChild(long weight, BaseThreadGroup.ThreadGroupChild child) {
        this.children.add(new WeightedChild(weight, child));
        return this;
    }

    public DslWeightedSwitchController children(BaseThreadGroup.ThreadGroupChild ... children) {
        this.addChildren(children);
        return this;
    }

    @Override
    public TestElement buildTestElement() {
        return new WeightedSwitchController();
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        WeightedSwitchController controller = (WeightedSwitchController)this.buildConfiguredTestElement();
        HashTree ret = parent.add((Object)controller);
        PowerTableModel model = this.buildDataModel();
        for (BaseThreadGroup.ThreadGroupChild child : this.children) {
            HashTree childTree = context.buildChild(child, ret);
            if (child instanceof WeightedChild) {
                this.addWeightedChildToModel(this.getChildName(ret, childTree), ((WeightedChild)child).weight, model);
                continue;
            }
            if (!(child instanceof DslSampler) && !(child instanceof DslController)) continue;
            this.addWeightedChildToModel(this.getChildName(ret, childTree), 100L, model);
        }
        controller.setData(model);
        return ret;
    }

    private String getChildName(HashTree tree, HashTree child) {
        return tree.list().stream().filter(t -> tree.getTree(t) == child).map(t -> ((TestElement)t).getName()).findAny().orElseThrow(IllegalStateException::new);
    }

    private PowerTableModel buildDataModel() {
        return new PowerTableModel(new String[]{"Name", "Weights", "Enabled"}, new Class[]{String.class, String.class, String.class});
    }

    private void addWeightedChildToModel(String name, long weight, PowerTableModel model) {
        model.addRow((Object[])new String[]{name, String.valueOf(weight), "true"});
    }

    private static class WeightedChild
    implements BaseThreadGroup.ThreadGroupChild {
        private final long weight;
        private final BaseThreadGroup.ThreadGroupChild element;

        private WeightedChild(long weight, BaseThreadGroup.ThreadGroupChild element) {
            this.weight = weight;
            this.element = element;
        }

        @Override
        public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
            return this.element.buildTreeUnder(parent, context);
        }

        @Override
        public void showInGui() {
            this.element.showInGui();
        }
    }
}

