/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;

public class TestResource {
    private final URL resource;

    public TestResource(String resourcePath) {
        ClassLoader loader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElse(TestResource.class.getClassLoader());
        this.resource = loader.getResource(resourcePath);
        if (this.resource == null) {
            throw new IllegalArgumentException("Could not access file associated to resource " + resourcePath);
        }
    }

    public File file() {
        try {
            return new File(this.resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String filePath() {
        return this.file().getPath();
    }

    public String contents() throws IOException {
        return String.join((CharSequence)"\n", Files.readAllLines(this.file().toPath(), StandardCharsets.UTF_8));
    }
}

