/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.threadgroups;

import com.blazemeter.jmeter.threads.concurrency.ConcurrencyThreadGroup;
import com.blazemeter.jmeter.threads.concurrency.ConcurrencyThreadGroupGui;
import java.awt.Component;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.timers.VariableThroughputTimer;
import kg.apc.jmeter.timers.VariableThroughputTimerGui;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.sampler.TestAction;
import org.apache.jmeter.sampler.gui.TestActionGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;
import us.abstracta.jmeter.javadsl.core.util.SingleSeriesTimelinePanel;

public class RpsThreadGroup
extends BaseThreadGroup<RpsThreadGroup> {
    private static int timerId = 1;
    private final List<TimerSchedule> schedules = new ArrayList<TimerSchedule>();
    private double lastRps = 1.0;
    private EventType counting = EventType.REQUESTS;
    private int initThreads = 1;
    private int maxThreads = Integer.MAX_VALUE;
    private double spareThreads = 0.1;

    public RpsThreadGroup(String name) {
        super(name != null ? name : "RPS Thread Group", (Class<? extends JMeterGUIComponent>)ConcurrencyThreadGroupGui.class, Collections.emptyList());
    }

    public RpsThreadGroup rampTo(double rps, Duration duration) {
        if (rps < 0.0) {
            throw new IllegalArgumentException("RPS must be >=0");
        }
        if (!Duration.ZERO.equals(duration)) {
            this.schedules.add(new TimerSchedule(this.lastRps, rps, duration));
        }
        this.lastRps = rps;
        return this;
    }

    public RpsThreadGroup holdFor(Duration duration) {
        if (!Duration.ZERO.equals(duration)) {
            this.schedules.add(new TimerSchedule(this.lastRps, this.lastRps, duration));
        }
        return this;
    }

    public RpsThreadGroup rampToAndHold(double rps, Duration rampDuration, Duration holdDuration) {
        return this.rampTo(rps, rampDuration).holdFor(holdDuration);
    }

    public RpsThreadGroup counting(EventType counting) {
        this.counting = counting;
        return this;
    }

    public RpsThreadGroup maxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public RpsThreadGroup initThreads(int initThreads) {
        this.initThreads = initThreads;
        return this;
    }

    public RpsThreadGroup spareThreads(double spareThreads) {
        this.spareThreads = spareThreads;
        return this;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        HashTree ret = parent.add((Object)this.buildConfiguredTestElement());
        HashTree timerParent = this.counting == EventType.ITERATIONS ? ret.add((Object)this.buildTestAction()) : ret;
        timerParent.add((Object)this.buildTimer());
        this.children.forEach(c -> context.buildChild((DslTestElement)c, ret));
        return ret;
    }

    private TestElement buildTestAction() {
        TestAction ret = new TestAction();
        ret.setAction(1);
        ret.setDuration("0");
        RpsThreadGroup.configureTestElement((TestElement)ret, "Flow Control Action", TestActionGui.class);
        return ret;
    }

    private TestElement buildTimer() {
        VariableThroughputTimer ret = new VariableThroughputTimer();
        ret.setData(this.buildTimerSchedulesData());
        RpsThreadGroup.configureTestElement((TestElement)ret, this.buildTimerName(timerId++), VariableThroughputTimerGui.class);
        return ret;
    }

    private String buildTimerName(int id) {
        return "rpsTimer" + id;
    }

    private CollectionProperty buildTimerSchedulesData() {
        PowerTableModel table = new PowerTableModel(new String[]{"Start RPS", "End RPS", "Duration, sec"}, new Class[]{String.class, String.class, String.class});
        this.schedules.forEach(s -> table.addRow(s.buildTableRow()));
        return JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)table, (String)"load_profile");
    }

    @Override
    protected AbstractThreadGroup buildThreadGroup() {
        ConcurrencyThreadGroup ret = new ConcurrencyThreadGroup();
        ret.setTargetLevel(String.format(Locale.US, "${__tstFeedback(%s,%d,%d,%.2f)}", this.buildTimerName(timerId), this.initThreads, this.maxThreads, this.spareThreads));
        ret.setHold(String.valueOf(this.schedules.stream().mapToLong(s -> ((TimerSchedule)s).durationSecs).sum()));
        ret.setUnit("S");
        return ret;
    }

    public void showTimeline() {
        SingleSeriesTimelinePanel chart = new SingleSeriesTimelinePanel(this.counting.label + " per second");
        if (!this.schedules.isEmpty()) {
            chart.add(0L, this.schedules.get(0).fromRps);
            this.schedules.forEach(s -> chart.add(((TimerSchedule)s).durationSecs * 1000L, ((TimerSchedule)s).toRps));
        }
        this.showAndWaitFrameWith((Component)((Object)chart), this.name + " timeline", 800, 300);
    }

    public static enum EventType {
        REQUESTS("Requests"),
        ITERATIONS("Iterations");

        private final String label;

        private EventType(String label) {
            this.label = label;
        }
    }

    private static class TimerSchedule {
        private final double fromRps;
        private final double toRps;
        private final long durationSecs;

        private TimerSchedule(double fromRps, double toRps, Duration durationSecs) {
            this.fromRps = fromRps;
            this.toRps = toRps;
            this.durationSecs = RpsThreadGroup.durationToSeconds(durationSecs);
        }

        public Object[] buildTableRow() {
            return new Object[]{String.valueOf(this.fromRps), String.valueOf(this.toRps), String.valueOf(this.durationSecs)};
        }
    }
}

