/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.http.entity.ContentType;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import us.abstracta.jmeter.javadsl.JmeterDsl;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.preprocessors.DslJsr223PreProcessor;
import us.abstracta.jmeter.javadsl.core.testelements.DslSampler;
import us.abstracta.jmeter.javadsl.http.DslCacheManager;
import us.abstracta.jmeter.javadsl.http.DslCookieManager;
import us.abstracta.jmeter.javadsl.http.HttpHeaders;
import us.abstracta.jmeter.javadsl.http.JmeterUrl;

public class DslHttpSampler
extends DslSampler<DslHttpSampler> {
    private String protocol;
    private String host;
    private String port;
    private String path;
    private String method = "GET";
    private final List<HTTPArgument> arguments = new ArrayList<HTTPArgument>();
    private final HttpHeaders headers = new HttpHeaders();
    private String body;
    private boolean multiPart;
    private final List<HTTPFileArg> files = new ArrayList<HTTPFileArg>();
    private Charset encoding;
    private boolean followRedirects = true;
    private boolean downloadEmbeddedResources;
    private HttpClientImpl clientImpl;

    public DslHttpSampler(String name, String url) {
        super(DslHttpSampler.buildName(name), HttpTestSampleGui.class);
        if (url == null) {
            return;
        }
        JmeterUrl parsedUrl = JmeterUrl.valueOf(url);
        this.protocol = parsedUrl.protocol();
        this.host = parsedUrl.host();
        this.port = parsedUrl.port();
        this.path = parsedUrl.path();
    }

    public DslHttpSampler(String name, Function<DslJsr223PreProcessor.PreProcessorVars, String> urlSupplier) {
        super(DslHttpSampler.buildName(name), HttpTestSampleGui.class);
        String variableName = "PRE_PROCESSOR_URL";
        this.path = "${" + variableName + "}";
        this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableName, (String)urlSupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    private static String buildName(String name) {
        return name != null ? name : "HTTP Request";
    }

    public DslHttpSampler protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public DslHttpSampler host(String host) {
        this.host = host;
        return this;
    }

    public DslHttpSampler port(int port) {
        this.port = String.valueOf(port);
        return this;
    }

    @Deprecated
    public DslHttpSampler post(String body, MimeTypes.Type contentType) {
        return this.method(HttpMethod.POST).contentType(contentType).body(body);
    }

    public DslHttpSampler post(String body, ContentType contentType) {
        return this.method("POST").contentType(contentType).body(body);
    }

    @Deprecated
    public DslHttpSampler post(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier, MimeTypes.Type contentType) {
        return this.method(HttpMethod.POST).contentType(contentType).body(bodySupplier);
    }

    public DslHttpSampler post(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier, ContentType contentType) {
        return this.method("POST").contentType(contentType).body(bodySupplier);
    }

    @Deprecated
    public DslHttpSampler method(HttpMethod method) {
        this.method = method.toString();
        return this;
    }

    public DslHttpSampler method(String method) {
        this.method = method;
        return this;
    }

    public DslHttpSampler header(String name, String value) {
        this.headers.header(name, value);
        return this;
    }

    public DslHttpSampler header(String name, Function<DslJsr223PreProcessor.PreProcessorVars, String> valueSupplier) {
        String variableNamePrefix = "PRE_PROCESSOR_HEADER~";
        this.headers.header(name, "${" + variableNamePrefix + name + "}");
        return (DslHttpSampler)this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableNamePrefix + name, (String)valueSupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    @Deprecated
    public DslHttpSampler contentType(MimeTypes.Type contentType) {
        this.headers.contentType(contentType);
        return this;
    }

    public DslHttpSampler contentType(ContentType contentType) {
        this.headers.contentType(contentType);
        return this;
    }

    public DslHttpSampler body(String body) {
        this.body = body;
        return this;
    }

    public DslHttpSampler body(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier) {
        String variableName = "PRE_PROCESSOR_REQUEST_BODY";
        this.body = "${" + variableName + "}";
        return (DslHttpSampler)this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableName, (String)bodySupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    public DslHttpSampler param(String name, String value) {
        this.arguments.add(new HTTPArgument(name, value));
        return this;
    }

    public DslHttpSampler encodedParam(String name, String value) {
        this.arguments.add(new HTTPArgument(name, value, true));
        return this;
    }

    public DslHttpSampler bodyPart(String name, String value, ContentType contentType) {
        this.arguments.add(new HTTPArgument(name, value, contentType.toString()));
        this.multiPart = true;
        return this;
    }

    public DslHttpSampler bodyFilePart(String name, String filePath, ContentType contentType) {
        this.multiPart = true;
        this.files.add(new HTTPFileArg(filePath, name, contentType.toString()));
        return this;
    }

    public DslHttpSampler encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslHttpSampler followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public DslHttpSampler downloadEmbeddedResources() {
        this.downloadEmbeddedResources = true;
        return this;
    }

    public DslHttpSampler clientImpl(HttpClientImpl clientImpl) {
        this.clientImpl = clientImpl;
        return this;
    }

    @Override
    public TestElement buildTestElement() {
        HTTPSamplerProxy ret = new HTTPSamplerProxy();
        if (this.protocol != null) {
            ret.setProtocol(this.protocol);
        }
        if (this.host != null) {
            ret.setDomain(this.host);
        }
        if (this.port != null) {
            ret.setProperty("HTTPSampler.port", this.port);
        }
        if (this.path != null) {
            ret.setPath(this.path);
        }
        ret.setMethod(this.method);
        ret.setArguments(this.buildArguments());
        if (this.multiPart) {
            ret.setDoMultipart(this.multiPart);
        }
        ret.setHTTPFiles(this.files.toArray(new HTTPFileArg[0]));
        if (this.encoding != null) {
            ret.setContentEncoding(this.encoding.toString());
        }
        ret.setFollowRedirects(this.followRedirects);
        ret.setUseKeepAlive(true);
        if (this.downloadEmbeddedResources) {
            ret.setImageParser(true);
            ret.setConcurrentDwn(true);
        }
        if (this.clientImpl != null) {
            ret.setImplementation(this.clientImpl.propertyValue);
        }
        return ret;
    }

    private Arguments buildArguments() {
        Arguments args = new Arguments();
        if (this.body != null) {
            HTTPArgument arg = new HTTPArgument("", this.body, false);
            arg.setAlwaysEncoded(false);
            args.addArgument((Argument)arg);
        }
        this.arguments.forEach(arg_0 -> ((Arguments)args).addArgument(arg_0));
        return args;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        HashTree ret = super.buildTreeUnder(parent, context);
        if (!this.headers.isEmpty()) {
            this.headers.buildTreeUnder(ret, context);
        }
        new DslCookieManager().buildTreeUnder(null, context);
        new DslCacheManager().buildTreeUnder(null, context);
        return ret;
    }

    public static enum HttpClientImpl {
        JAVA("Java"),
        HTTP_CLIENT("HttpClient4");

        public final String propertyValue;

        private HttpClientImpl(String propertyValue) {
            this.propertyValue = propertyValue;
        }
    }
}

