/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.time.Duration;
import java.time.Instant;
import org.apache.jmeter.report.processor.StatisticsSummaryData;
import org.apache.jmeter.samplers.SampleResult;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;

public class AggregatingTestPlanStats
extends TestPlanStats {
    public AggregatingTestPlanStats() {
        this.setOverallStats(new AggregatingStatsSummary());
    }

    public void addSampleResult(SampleResult result) {
        ((AggregatingStatsSummary)this.overallStats).addResult(result);
        AggregatingStatsSummary labelStats = (AggregatingStatsSummary)this.labeledStats.computeIfAbsent(result.getSampleLabel(), label -> new AggregatingStatsSummary());
        labelStats.addResult(result);
    }

    public static class AggregatingStatsSummary
    implements TestPlanStats.StatsSummary {
        private final StatisticsSummaryData stats = new StatisticsSummaryData(90L, 95L, 99L);

        private void addResult(SampleResult result) {
            this.stats.incTotal();
            this.stats.incBytes(result.getBytesAsLong());
            this.stats.incSentBytes(result.getSentBytes());
            if (!result.isSuccessful()) {
                this.stats.incErrors();
            }
            this.updateElapsedTime(result.getTime());
            this.stats.setFirstTime(result.getStartTime());
            this.stats.setEndTime(result.getEndTime());
        }

        private void updateElapsedTime(long elapsedTime) {
            this.stats.getPercentile1().addValue((double)elapsedTime);
            this.stats.getPercentile2().addValue((double)elapsedTime);
            this.stats.getPercentile3().addValue((double)elapsedTime);
            this.stats.getMean().addValue((double)elapsedTime);
            this.stats.setMin(elapsedTime);
            this.stats.setMax(elapsedTime);
        }

        @Override
        public Instant firstTime() {
            return Instant.ofEpochMilli(this.stats.getFirstTime());
        }

        @Override
        public Instant endTime() {
            return Instant.ofEpochMilli(this.stats.getEndTime());
        }

        @Override
        public Duration elapsedTime() {
            return Duration.ofMillis(this.stats.getElapsedTime());
        }

        @Override
        public long samplesCount() {
            return this.stats.getTotal();
        }

        @Override
        public double samplesPerSecond() {
            return this.stats.getThroughput();
        }

        @Override
        public long errorsCount() {
            return this.stats.getErrors();
        }

        @Override
        public Duration minElapsedTime() {
            return Duration.ofMillis(this.stats.getMin());
        }

        @Override
        public Duration maxElapsedTime() {
            return Duration.ofMillis(this.stats.getMax());
        }

        @Override
        public Duration meanElapsedTime() {
            return Duration.ofMillis((long)this.stats.getMean().getResult());
        }

        @Override
        public Duration elapsedTimePercentile90() {
            return Duration.ofMillis((long)this.stats.getPercentile1().getResult());
        }

        @Override
        public Duration elapsedTimePercentile95() {
            return Duration.ofMillis((long)this.stats.getPercentile2().getResult());
        }

        @Override
        public Duration elapsedTimePercentile99() {
            return Duration.ofMillis((long)this.stats.getPercentile3().getResult());
        }

        @Override
        public long receivedBytes() {
            return this.stats.getBytes();
        }

        @Override
        public double receivedBytesPerSecond() {
            return this.stats.getBytesPerSecond();
        }

        @Override
        public long sentBytes() {
            return this.stats.getSentBytes();
        }

        @Override
        public double sentBytesPerSecond() {
            return this.stats.getSentBytesPerSecond();
        }
    }
}

