/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.awt.Color;
import java.awt.Component;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.swing.BorderFactory;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.charting.GraphPanelChart;
import kg.apc.charting.rows.GraphRowSimple;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.threads.UltimateThreadGroup;
import kg.apc.jmeter.threads.UltimateThreadGroupGui;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import org.apache.jorphan.gui.NumberRenderer;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestElementContainer;

public class DslThreadGroup
extends TestElementContainer<ThreadGroupChild>
implements DslTestPlan.TestPlanChild {
    private final List<Stage> stages = new ArrayList<Stage>();

    public DslThreadGroup(String name, int threads, int iterations, List<ThreadGroupChild> children) {
        super(DslThreadGroup.solveName(name), null, children);
        this.checkThreadCount(threads);
        if (iterations <= 0) {
            throw new IllegalArgumentException("Iterations must be >=1");
        }
        this.stages.add(new Stage(threads, Duration.ZERO));
        this.stages.add(new Stage(threads, iterations));
    }

    public DslThreadGroup(String name, int threads, Duration duration, List<ThreadGroupChild> children) {
        super(DslThreadGroup.solveName(name), null, children);
        this.checkThreadCount(threads);
        this.stages.add(new Stage(threads, Duration.ZERO));
        this.stages.add(new Stage(threads, duration));
    }

    public DslThreadGroup(String name) {
        super(DslThreadGroup.solveName(name), null, Collections.emptyList());
    }

    private void checkThreadCount(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Threads count must be >=1");
        }
    }

    private static String solveName(String name) {
        return name != null ? name : "Thread Group";
    }

    @Deprecated
    public DslThreadGroup rampUpPeriod(Duration rampUpPeriod) {
        if (this.stages.isEmpty()) {
            throw new IllegalStateException("To use rampUpPeriod you need to specify threads in threadGroup");
        }
        this.stages.get(0).duration = rampUpPeriod;
        return this;
    }

    public DslThreadGroup rampTo(int threadCount, Duration duration) {
        if (threadCount < 0) {
            throw new IllegalArgumentException("Thread count must be >=0");
        }
        if (!this.stages.isEmpty() && this.getLastStage().duration == null) {
            throw new IllegalStateException("Ramping up/down after holding for iterations is not supported");
        }
        this.stages.add(new Stage(threadCount, duration));
        return this;
    }

    private Stage getLastStage() {
        return this.stages.get(this.stages.size() - 1);
    }

    public DslThreadGroup holdFor(Duration duration) {
        int threadsCount = this.stages.isEmpty() ? 0 : this.getLastStage().threadCount;
        this.stages.add(new Stage(threadsCount, duration));
        return this;
    }

    public DslThreadGroup holdIterating(int iterations) {
        if (iterations < 0) {
            throw new IllegalArgumentException("Iterations must be >=0");
        }
        if (!(this.stages.size() == 1 && this.stages.get(0).threadCount != 0 || this.stages.size() == 2 && this.stages.get(0).threadCount == 0 && this.stages.get(1).threadCount != 0)) {
            throw new IllegalStateException("Holding for iterations is only supported after initial hold and ramp, or ramp.");
        }
        this.stages.add(new Stage(this.getLastStage().threadCount, iterations));
        return this;
    }

    public DslThreadGroup rampToAndHold(int threads, Duration rampDuration, Duration holdDuration) {
        return this.rampTo(threads, rampDuration).holdFor(holdDuration);
    }

    public DslThreadGroup children(ThreadGroupChild ... children) {
        return (DslThreadGroup)super.children((DslTestElement[])children);
    }

    @Override
    public TestElement buildTestElement() {
        return this.isSimpleThreadGroup() ? this.buildSimpleThreadGroup() : this.buildUltimateThreadGroup();
    }

    private boolean isSimpleThreadGroup() {
        return this.stages.size() <= 1 || this.stages.size() == 2 && (this.stages.get(0).threadCount == 0 || this.stages.get(0).threadCount == this.stages.get(1).threadCount) || this.stages.size() == 3 && this.stages.get(0).threadCount == 0 && this.stages.get(1).threadCount == this.stages.get(2).threadCount;
    }

    private TestElement buildSimpleThreadGroup() {
        int threads = 1;
        int iterations = 1;
        Duration rampUpPeriod = null;
        Duration duration = null;
        Duration delay = null;
        if (!this.stages.isEmpty()) {
            Stage firstStage = this.stages.get(0);
            if (firstStage.threadCount == 0) {
                delay = firstStage.duration;
            } else {
                rampUpPeriod = firstStage.duration;
                threads = firstStage.threadCount;
            }
            iterations = firstStage.iterations;
            if (this.stages.size() > 1) {
                Stage secondStage = this.stages.get(1);
                threads = secondStage.threadCount;
                iterations = secondStage.iterations;
                if (firstStage.threadCount == 0) {
                    rampUpPeriod = secondStage.duration;
                    if (this.stages.size() > 2) {
                        Stage lastStage = this.stages.get(2);
                        duration = lastStage.duration;
                        iterations = lastStage.iterations;
                    }
                } else {
                    duration = secondStage.duration;
                }
            }
        }
        this.guiClass = ThreadGroupGui.class;
        return this.buildThreadGroup(threads, iterations, rampUpPeriod, duration, delay);
    }

    private ThreadGroup buildThreadGroup(int threads, int iterations, Duration rampUpPeriod, Duration duration, Duration delay) {
        ThreadGroup ret = new ThreadGroup();
        ret.setNumThreads(Math.max(threads, 1));
        ret.setRampUp((int)DslThreadGroup.extractDurationSeconds(rampUpPeriod == null ? Duration.ZERO : rampUpPeriod));
        LoopController loopController = new LoopController();
        ret.setSamplerController(loopController);
        if (duration != null) {
            loopController.setLoops(-1);
            ret.setDuration(DslThreadGroup.extractDurationSeconds(duration));
        } else {
            loopController.setLoops(iterations);
        }
        if (delay != null) {
            ret.setDelay(DslThreadGroup.extractDurationSeconds(delay));
        }
        if (duration != null || delay != null) {
            ret.setScheduler(true);
        }
        return ret;
    }

    private static long extractDurationSeconds(Duration duration) {
        return Math.round(Math.ceil((double)duration.toMillis() / 1000.0));
    }

    private TestElement buildUltimateThreadGroup() {
        this.guiClass = UltimateThreadGroupGui.class;
        UltimateThreadGroup ret = new UltimateThreadGroup();
        PowerTableModel table = new PowerTableModel(UltimateThreadGroupGui.columnIdentifiers, UltimateThreadGroupGui.columnClasses);
        this.buildUltimateThreadGroupSchedules().forEach(s -> table.addRow(s.buildTableRow()));
        ret.setData(JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)table, (String)"ultimatethreadgroupdata"));
        LoopController loopController = new LoopController();
        loopController.setLoops(-1);
        loopController.setContinueForever(true);
        ret.setSamplerController(loopController);
        return ret;
    }

    private List<UltimateThreadSchedule> buildUltimateThreadGroupSchedules() {
        ArrayList<UltimateThreadSchedule> ret = new ArrayList<UltimateThreadSchedule>();
        Duration delay = Duration.ZERO;
        int threads = 0;
        Stack<UltimateThreadSchedule> stack = new Stack<UltimateThreadSchedule>();
        UltimateThreadSchedule curr = new UltimateThreadSchedule(0, Duration.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO);
        for (Stage s : this.stages) {
            if (s.threadCount == threads) {
                curr.hold = curr.hold.plus(s.duration);
            } else if (s.threadCount > threads) {
                stack.add(curr);
                curr = new UltimateThreadSchedule(s.threadCount - threads, delay, s.duration, Duration.ZERO, Duration.ZERO);
            } else {
                int diff = threads - s.threadCount;
                Duration shutdown = s.duration;
                while (diff > curr.threadCount) {
                    curr.shutdown = DslThreadGroup.interpolateDurationForThreadCountWithRamp(curr.threadCount, diff, shutdown);
                    diff -= curr.threadCount;
                    shutdown = shutdown.minus(curr.shutdown);
                    curr = this.completeCurrentSchedule(curr, ret, stack);
                }
                if (diff == curr.threadCount) {
                    curr.shutdown = shutdown;
                } else {
                    Duration start = DslThreadGroup.interpolateDurationForThreadCountWithRamp(diff, curr.threadCount, curr.startup);
                    UltimateThreadSchedule last = curr;
                    curr = new UltimateThreadSchedule(diff, curr.delay.plus(curr.startup).minus(start), start, curr.hold, shutdown);
                    UltimateThreadSchedule ultimateThreadSchedule = last;
                    ultimateThreadSchedule.threadCount = ultimateThreadSchedule.threadCount - diff;
                    last.startup = last.startup.minus(start);
                    last.hold = Duration.ZERO;
                    stack.push(last);
                }
                curr = this.completeCurrentSchedule(curr, ret, stack);
            }
            threads = s.threadCount;
            delay = delay.plus(s.duration);
        }
        if (!stack.isEmpty()) {
            ret.add(curr);
            while (!stack.isEmpty()) {
                ret.add((UltimateThreadSchedule)stack.pop());
            }
            ret.remove(ret.size() - 1);
        }
        ret.sort(Comparator.comparing(r -> ((UltimateThreadSchedule)r).delay.toMillis()));
        return ret;
    }

    private static Duration interpolateDurationForThreadCountWithRamp(int threadCount, int rampThreads, Duration rampDuration) {
        return Duration.ofMillis((long)((double)rampDuration.toMillis() * ((double)threadCount / (double)rampThreads)));
    }

    private UltimateThreadSchedule completeCurrentSchedule(UltimateThreadSchedule curr, List<UltimateThreadSchedule> ret, Stack<UltimateThreadSchedule> stack) {
        ret.add(curr);
        UltimateThreadSchedule last = curr;
        curr = stack.pop();
        curr.hold = curr.hold.plus(last.startup).plus(last.hold).plus(last.shutdown);
        return curr;
    }

    public void showThreadsTimeline() {
        this.showFrameWith(this.buildGraphPanel(), 800, 300);
    }

    private Component buildGraphPanel() {
        GraphPanelChart ret = new GraphPanelChart(false, true);
        ret.getChartSettings().setDrawFinalZeroingLines(true);
        ret.setxAxisLabel("Time");
        ret.setYAxisLabel("Threads");
        ret.setxAxisLabelRenderer((NumberRenderer)new DateTimeRenderer("HH:mm:ss", 0L));
        ret.setBorder(BorderFactory.createBevelBorder(1));
        ret.setForcedMinX(0L);
        HashMap<String, GraphRowSimple> model = new HashMap<String, GraphRowSimple>();
        model.put("Threads", this.buildThreadsSeries());
        ret.setRows(model);
        return ret;
    }

    private GraphRowSimple buildThreadsSeries() {
        GraphRowSimple ret = new GraphRowSimple();
        ret.setColor(Color.RED);
        ret.setDrawLine(true);
        ret.setMarkerSize(0);
        ret.add(0L, 0.0);
        long delayMillis = 0L;
        for (Stage s : this.stages) {
            ret.add(delayMillis += s.duration.toMillis(), (double)s.threadCount);
        }
        return ret;
    }

    public static interface ThreadGroupChild
    extends DslTestElement {
    }

    protected static class UltimateThreadSchedule {
        private int threadCount;
        private final Duration delay;
        private Duration startup;
        private Duration hold;
        private Duration shutdown;

        public UltimateThreadSchedule(int threadCount, Duration delay, Duration startup, Duration hold, Duration shutdown) {
            this.threadCount = threadCount;
            this.delay = delay;
            this.startup = startup;
            this.hold = hold;
            this.shutdown = shutdown;
        }

        public Object[] buildTableRow() {
            return new Object[]{String.valueOf(this.threadCount), String.valueOf(DslThreadGroup.extractDurationSeconds(this.delay)), String.valueOf(DslThreadGroup.extractDurationSeconds(this.startup)), String.valueOf(DslThreadGroup.extractDurationSeconds(this.hold)), String.valueOf(DslThreadGroup.extractDurationSeconds(this.shutdown))};
        }
    }

    private static class Stage {
        private final int threadCount;
        private Duration duration;
        private final int iterations;

        private Stage(int threadCount, Duration duration) {
            this.threadCount = threadCount;
            this.duration = duration;
            this.iterations = 0;
        }

        private Stage(int threadCount, int iterations) {
            this.threadCount = threadCount;
            this.iterations = iterations;
            this.duration = null;
        }
    }
}

