/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import java.time.Instant;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.visualizers.backend.BackendListener;
import org.apache.jmeter.visualizers.backend.BackendListenerGui;
import org.apache.jmeter.visualizers.backend.influxdb.InfluxdbBackendListenerClient;
import us.abstracta.jmeter.javadsl.core.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.MultiLevelTestElement;

public class InfluxDbBackendListener
extends BaseTestElement
implements MultiLevelTestElement {
    private final String url;
    private String title = "Test jmeter-java-dsl " + Instant.now().toString();
    private String token;
    private int queueSize = 5000;

    public InfluxDbBackendListener(String url) {
        super("Backend Listener", BackendListenerGui.class);
        this.url = url;
    }

    public InfluxDbBackendListener title(String title) {
        this.title = title;
        return this;
    }

    public InfluxDbBackendListener token(String token) {
        this.token = token;
        return this;
    }

    public InfluxDbBackendListener queueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        BackendListener ret = new BackendListener();
        ret.setClassname(InfluxdbBackendListenerClient.class.getName());
        ret.setQueueSize(String.valueOf(this.queueSize));
        ret.setArguments(this.buildArguments());
        return ret;
    }

    private Arguments buildArguments() {
        Arguments ret = new InfluxdbBackendListenerClient().getDefaultParameters();
        this.setArgument("influxdbUrl", this.url, ret);
        this.setArgument("summaryOnly", "false", ret);
        this.setArgument("testTitle", this.title, ret);
        if (this.token != null) {
            this.setArgument("influxdbToken", this.token, ret);
        }
        return ret;
    }

    private void setArgument(String name, String value, Arguments args) {
        args.removeArgument(name);
        args.addArgument(name, value);
    }
}

