/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.functions.EvalFunction;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import us.abstracta.jmeter.javadsl.core.AggregatingTestPlanStats;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;

public class EmbeddedJmeterEngine
implements DslJmeterEngine {
    @Override
    public TestPlanStats run(DslTestPlan testPlan) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();){
            StandardJMeterEngine engine = new StandardJMeterEngine();
            ListedHashTree rootTree = new ListedHashTree();
            HashTree testPlanTree = testPlan.buildTreeUnder((HashTree)rootTree, new BuildTreeContext((HashTree)rootTree));
            AggregatingTestPlanStats stats = new AggregatingTestPlanStats();
            this.addTestStatsCollectorToTree(stats, testPlanTree);
            this.addTestSummariserToTree(testPlanTree);
            engine.configure((HashTree)rootTree);
            stats.setStart(Instant.now());
            engine.run();
            stats.setEnd(Instant.now());
            AggregatingTestPlanStats aggregatingTestPlanStats = stats;
            return aggregatingTestPlanStats;
        }
    }

    private void addTestStatsCollectorToTree(final AggregatingTestPlanStats stats, HashTree tree) {
        ResultCollector collector = new ResultCollector();
        Visualizer statsVisualizer = new Visualizer(){

            public void add(SampleResult r) {
                stats.addSampleResult(r);
            }

            public boolean isStats() {
                return true;
            }
        };
        collector.setListener(statsVisualizer);
        tree.add((Object)collector);
        tree.add((Object)statsVisualizer);
    }

    private void addTestSummariserToTree(HashTree tree) {
        tree.add((Object)new ResultCollector(new Summariser()));
    }

    public static void saveTestPlanToJmx(DslTestPlan dslTestPlan, String filePath) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();
             FileOutputStream output = new FileOutputStream(filePath);){
            ListedHashTree tree = new ListedHashTree();
            dslTestPlan.buildTreeUnder((HashTree)tree, new BuildTreeContext((HashTree)tree));
            SaveService.saveTree((HashTree)tree, (OutputStream)output);
        }
    }

    public static DslTestPlan loadTestPlanFromJmx(String filePath) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();){
            HashTree tree = SaveService.loadTree((File)new File(filePath));
            DslTestPlan dslTestPlan = DslTestPlan.fromTree(tree);
            return dslTestPlan;
        }
    }

    public static class JMeterEnvironment
    implements Closeable {
        private final File homeDir = Files.createTempDirectory("jmeter-java-dsl", new FileAttribute[0]).toFile();

        public JMeterEnvironment() throws IOException {
            try {
                JMeterUtils.setJMeterHome((String)this.homeDir.getPath());
                File binDir = new File(this.homeDir, "bin");
                this.installConfig(binDir);
                Properties props = JMeterUtils.getProperties((String)new File(binDir, "jmeter.properties").getPath());
                props.setProperty("search_paths", this.getFunctionsJarPath());
            }
            catch (IOException | RuntimeException e) {
                FileUtils.deleteDirectory((File)this.homeDir);
                throw e;
            }
        }

        private String getFunctionsJarPath() {
            try {
                return new File(EvalFunction.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private void installConfig(File binDir) throws IOException {
            try (FileSystem fs = FileSystems.newFileSystem(this.getClass().getResource("/bin/jmeter.properties").toURI(), Collections.emptyMap());){
                Path configBinDir = fs.getPath("/bin", new String[0]);
                for (Path p : Files.walk(configBinDir, new FileVisitOption[0])::iterator) {
                    Files.copy(p, binDir.toPath().resolve(configBinDir.relativize(p).toString()), new CopyOption[0]);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            FileUtils.deleteDirectory((File)this.homeDir);
        }
    }
}

