/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.time.Duration;
import java.util.List;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestElementContainer;

public class DslThreadGroup
extends TestElementContainer<ThreadGroupChild>
implements DslTestPlan.TestPlanChild {
    private final int threads;
    private final int iterations;
    private final Duration duration;
    private Duration rampUpPeriod = Duration.ZERO;

    public DslThreadGroup(String name, int threads, int iterations, List<ThreadGroupChild> children) {
        super(name != null ? name : "Thread Group", ThreadGroupGui.class, children);
        this.threads = threads;
        this.iterations = iterations;
        this.duration = null;
    }

    public DslThreadGroup(String name, int threads, Duration duration, List<ThreadGroupChild> children) {
        super(name != null ? name : "Thread Group", ThreadGroupGui.class, children);
        this.threads = threads;
        this.iterations = 0;
        this.duration = duration;
    }

    public DslThreadGroup rampUpPeriod(Duration rampUpPeriod) {
        this.rampUpPeriod = rampUpPeriod;
        return this;
    }

    public DslThreadGroup children(ThreadGroupChild ... children) {
        return (DslThreadGroup)super.children((DslTestElement[])children);
    }

    @Override
    public TestElement buildTestElement() {
        ThreadGroup ret = new ThreadGroup();
        ret.setNumThreads(this.threads);
        ret.setRampUp((int)this.extractDurationSeconds(this.rampUpPeriod));
        LoopController loopController = new LoopController();
        ret.setSamplerController(loopController);
        if (this.duration != null) {
            loopController.setLoops(-1);
            ret.setScheduler(true);
            ret.setDuration(this.extractDurationSeconds(this.duration));
        } else {
            loopController.setLoops(this.iterations);
        }
        return ret;
    }

    private long extractDurationSeconds(Duration duration) {
        return Math.round(Math.ceil((double)duration.toMillis() / 1000.0));
    }

    public static interface ThreadGroupChild
    extends DslTestElement {
    }
}

