/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.time.Duration;
import java.util.List;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestElementContainer;

public class DslThreadGroup
extends TestElementContainer<ThreadGroupChild>
implements DslTestPlan.TestPlanChild {
    private final int threads;
    private final int iterations;
    private final Duration duration;

    public DslThreadGroup(String name, int threads, int iterations, List<ThreadGroupChild> children) {
        super(name != null ? name : "Thread Group", ThreadGroupGui.class, children);
        this.threads = threads;
        this.iterations = iterations;
        this.duration = null;
    }

    public DslThreadGroup(String name, int threads, Duration duration, List<ThreadGroupChild> children) {
        super(name != null ? name : "Thread Group", ThreadGroupGui.class, children);
        this.threads = threads;
        this.iterations = 0;
        this.duration = duration;
    }

    @Override
    public TestElement buildTestElement() {
        ThreadGroup ret = new ThreadGroup();
        ret.setNumThreads(this.threads);
        LoopController loopController = new LoopController();
        ret.setSamplerController(loopController);
        if (this.duration != null) {
            loopController.setLoops(-1);
            ret.setScheduler(true);
            ret.setDuration(Math.round(Math.ceil((double)this.duration.toMillis() / 1000.0)));
        } else {
            loopController.setLoops(this.iterations);
        }
        return ret;
    }

    public static interface ThreadGroupChild
    extends DslTestElement {
    }
}

