/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.functions.EvalFunction;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;

public class EmbeddedJmeterEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestPlanStats run(DslTestPlan testPlan) throws IOException {
        Path propsFilePath = Files.createTempFile("jmeter", ".properties", new FileAttribute[0]);
        try {
            this.setupJMeterProperties(propsFilePath);
            StandardJMeterEngine engine = new StandardJMeterEngine();
            HashTree rootTree = new HashTree();
            HashTree testPlanTree = testPlan.buildTreeUnder(rootTree);
            TestPlanStats stats = new TestPlanStats();
            this.addTestStatsCollectorToTree(stats, testPlanTree);
            this.addTestSummariserToTree(testPlanTree);
            engine.configure(rootTree);
            engine.run();
            TestPlanStats testPlanStats = stats;
            return testPlanStats;
        }
        finally {
            propsFilePath.toFile().delete();
        }
    }

    private void setupJMeterProperties(Path propsFilePath) throws IOException {
        propsFilePath.toFile().delete();
        Files.copy(this.getClass().getResourceAsStream("/jmeter.properties"), propsFilePath, new CopyOption[0]);
        JMeterUtils.loadJMeterProperties((String)propsFilePath.toString());
        JMeterUtils.setProperty((String)"search_paths", (String)this.getFunctionsJarPath());
        JMeterUtils.setProperty((String)"saveservice_properties", (String)propsFilePath.toString());
    }

    private String getFunctionsJarPath() {
        try {
            return new File(EvalFunction.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void addTestStatsCollectorToTree(final TestPlanStats stats, HashTree tree) {
        ResultCollector collector = new ResultCollector();
        Visualizer statsVisualizer = new Visualizer(){

            public void add(SampleResult r) {
                stats.addSampleResult(r);
            }

            public boolean isStats() {
                return true;
            }
        };
        collector.setListener(statsVisualizer);
        tree.add((Object)collector);
        tree.add((Object)statsVisualizer);
    }

    private void addTestSummariserToTree(HashTree tree) {
        tree.add((Object)new ResultCollector(new Summariser()));
    }
}

