/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.blazemeter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.blazemeter.BlazeMeterClient;
import us.abstracta.jmeter.javadsl.blazemeter.api.Project;
import us.abstracta.jmeter.javadsl.blazemeter.api.Test;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRun;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunConfig;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunRequestStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunStatus;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunSummaryStats;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;

public class BlazeMeterEngine
implements DslJmeterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(BlazeMeterEngine.class);
    private static final String BASE_URL = "https://a.blazemeter.com";
    private static final Duration STATUS_POLL_PERIOD = Duration.ofSeconds(5L);
    private final BlazeMeterClient client;
    private String testName = "jmeter-java-dsl";
    private Long projectId;
    private Duration testTimeout = Duration.ofHours(1L);
    private Duration availableDataTimeout = Duration.ofSeconds(30L);
    private Integer totalUsers;
    private Duration rampUp;
    private Integer iterations;
    private Duration holdFor;
    private Integer threadsPerEngine;
    private boolean useDebugRun;

    public BlazeMeterEngine(String authToken) {
        this.client = new BlazeMeterClient("https://a.blazemeter.com/api/v4/", authToken);
    }

    public BlazeMeterEngine testName(String testName) {
        this.testName = testName;
        return this;
    }

    public BlazeMeterEngine projectId(long projectId) {
        this.projectId = projectId;
        return this;
    }

    public BlazeMeterEngine testTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    public BlazeMeterEngine availableDataTimeout(Duration availableDataTimeout) {
        this.availableDataTimeout = availableDataTimeout;
        return this;
    }

    public BlazeMeterEngine totalUsers(int totalUsers) {
        this.totalUsers = totalUsers;
        return this;
    }

    public BlazeMeterEngine rampUpFor(Duration rampUp) {
        this.rampUp = rampUp;
        return this;
    }

    public BlazeMeterEngine iterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public BlazeMeterEngine holdFor(Duration holdFor) {
        this.holdFor = holdFor;
        return this;
    }

    public BlazeMeterEngine threadsPerEngine(int threadsPerEngine) {
        this.threadsPerEngine = threadsPerEngine;
        return this;
    }

    public BlazeMeterEngine useDebugRun() {
        this.useDebugRun = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestPlanStats run(DslTestPlan testPlan) throws IOException, InterruptedException, TimeoutException {
        Project project = this.findProject();
        File jmxFile = Files.createTempDirectory("jmeter-dsl", new FileAttribute[0]).resolve("test.jmx").toFile();
        try {
            this.saveTestPlanTo(testPlan, jmxFile);
            Test test = this.client.findTestByName(this.testName, project).orElse(null);
            TestConfig testConfig = this.buildTestConfig(project, jmxFile);
            if (test != null) {
                this.client.updateTest(test, testConfig);
                LOG.info("Updated test {}", (Object)test.getUrl());
            } else {
                test = this.client.createTest(testConfig, project);
                LOG.info("Created test {}", (Object)test.getUrl());
            }
            this.client.uploadTestFile(test, jmxFile);
            TestRun testRun = this.client.startTest(test, this.buildTestRunConfig());
            LOG.info("Started test run {}", (Object)testRun.getUrl());
            this.awaitTestEnd(testRun);
            TestPlanStats testPlanStats = this.findTestPlanStats(testRun);
            return testPlanStats;
        }
        finally {
            if (jmxFile.delete()) {
                jmxFile.getParentFile().delete();
            }
        }
    }

    private Project findProject() throws IOException {
        String appBaseUrl = "https://a.blazemeter.com/app/#";
        return this.projectId == null ? this.client.findDefaultProject(appBaseUrl) : this.client.findProjectById(this.projectId, appBaseUrl);
    }

    private void saveTestPlanTo(DslTestPlan testPlan, File jmxFile) throws IOException {
        try (JmeterEnvironment env = new JmeterEnvironment();
             FileOutputStream output = new FileOutputStream(jmxFile.getPath());){
            ListedHashTree tree = new ListedHashTree();
            BuildTreeContext context = new BuildTreeContext((HashTree)tree);
            testPlan.buildTreeUnder((HashTree)tree, context);
            env.saveTree((HashTree)tree, output);
            context.getVisualizers().forEach((v, e) -> LOG.warn("BlazeMeterEngine does not currently support displaying visualizers. Ignoring {}.", (Object)v.getClass().getSimpleName()));
        }
    }

    private TestConfig buildTestConfig(Project project, File jmxFile) {
        return new TestConfig().name(this.testName).projectId(project.getId()).jmxFile(jmxFile).totalUsers(this.totalUsers).rampUp(this.rampUp).iterations(this.iterations).holdFor(this.holdFor).threadsPerEngine(this.threadsPerEngine);
    }

    private TestRunConfig buildTestRunConfig() {
        TestRunConfig ret = new TestRunConfig();
        if (this.useDebugRun) {
            ret.debugRun();
        }
        return ret;
    }

    private void awaitTestEnd(TestRun testRun) throws InterruptedException, IOException, TimeoutException {
        TestRunStatus status = TestRunStatus.CREATED;
        Instant testStart = Instant.now();
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            TestRunStatus newStatus = this.client.findTestRunStatus(testRun);
            if (status.equals(newStatus)) continue;
            LOG.debug("Test run {} status changed to: {}", (Object)testRun.getUrl(), (Object)newStatus);
            status = newStatus;
        } while (!TestRunStatus.ENDED.equals(status) && !this.hasTimedOut(testStart, this.testTimeout));
        if (!TestRunStatus.ENDED.equals(status)) {
            throw this.buildTestTimeoutException(testRun);
        }
        if (!status.isDataAvailable()) {
            this.awaitAvailableData(testRun, testStart);
        }
    }

    private boolean hasTimedOut(Instant start, Duration timeout) {
        return Duration.between(start, Instant.now()).compareTo(timeout) >= 0;
    }

    private TimeoutException buildTestTimeoutException(TestRun testRun) {
        return new TimeoutException(String.format("Test %s didn't end after %s. If the timeout is too short, you can change it with testTimeout() method.", testRun.getUrl(), this.testTimeout));
    }

    private void awaitAvailableData(TestRun testRun, Instant testStart) throws InterruptedException, IOException, TimeoutException {
        TestRunStatus status;
        Instant dataPollStart = Instant.now();
        do {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
        } while (!(status = this.client.findTestRunStatus(testRun)).isDataAvailable() && !this.hasTimedOut(testStart, this.testTimeout) && !this.hasTimedOut(dataPollStart, this.availableDataTimeout));
        if (this.hasTimedOut(testStart, this.testTimeout)) {
            throw this.buildTestTimeoutException(testRun);
        }
        if (!status.isDataAvailable()) {
            throw new TimeoutException(String.format("Test %s ended, but no data is available after %s. This is usually caused by some failure in BlazeMeter. Check bzt.log and jmeter.out, and if everything looks good you might try increasing this timeout with availableDataTimeout() method.", testRun.getUrl(), this.availableDataTimeout));
        }
    }

    private TestPlanStats findTestPlanStats(TestRun testRun) throws IOException {
        TestRunSummaryStats.TestRunLabeledSummary summary = this.client.findTestRunSummaryStats(testRun).getSummary().get(0);
        List<TestRunRequestStats> labeledStats = this.client.findTestRunRequestStats(testRun);
        return this.buildTestStats(summary, labeledStats);
    }

    private TestPlanStats buildTestStats(TestRunSummaryStats.TestRunLabeledSummary summary, List<TestRunRequestStats> labeledStats) {
        TestPlanStats stats = new TestPlanStats();
        for (TestRunRequestStats labeledStat : labeledStats) {
            BlazemeterStatsSummary labelStatsSummary = new BlazemeterStatsSummary(labeledStat, summary);
            if ("ALL".equals(labeledStat.getLabelName())) {
                stats.setOverallStats((TestPlanStats.StatsSummary)labelStatsSummary);
                continue;
            }
            stats.setLabeledStats(labeledStat.getLabelName(), (TestPlanStats.StatsSummary)labelStatsSummary);
        }
        return stats;
    }

    private static class BlazemeterStatsSummary
    implements TestPlanStats.StatsSummary {
        private final Instant firstTime;
        private final Instant endTime;
        private final Duration elapsedTime;
        private final long samplesCount;
        private final double samplesPerSecond;
        private final long errorsCount;
        private final Duration minSampleTime;
        private final Duration maxSampleTime;
        private final Duration meanSampleTime;
        private final Duration sampleTimePercentile90;
        private final Duration sampleTimePercentile95;
        private final Duration sampleTimePercentile99;
        private final long receivedBytes;
        private final double receivedBytesPerSecond;

        private BlazemeterStatsSummary(TestRunRequestStats labeledStat, TestRunSummaryStats.TestRunLabeledSummary summary) {
            this.firstTime = summary.getFirst();
            this.endTime = summary.getLast();
            this.elapsedTime = Duration.ofMillis(labeledStat.getDuration());
            this.samplesCount = labeledStat.getSamples();
            this.samplesPerSecond = labeledStat.getAvgThroughput();
            this.errorsCount = labeledStat.getErrorsCount();
            this.minSampleTime = Duration.ofMillis(labeledStat.getMinResponseTime());
            this.maxSampleTime = Duration.ofMillis(labeledStat.getMaxResponseTime());
            this.meanSampleTime = Duration.ofMillis(Math.round(labeledStat.getAvgResponseTime()));
            this.sampleTimePercentile90 = Duration.ofMillis(labeledStat.getPerc90());
            this.sampleTimePercentile95 = Duration.ofMillis(labeledStat.getPerc95());
            this.sampleTimePercentile99 = Duration.ofMillis(labeledStat.getPerc99());
            this.receivedBytes = Math.round(labeledStat.getAvgBytes() / 1000.0 * (double)labeledStat.getDuration());
            this.receivedBytesPerSecond = labeledStat.getAvgBytes();
        }

        public Instant firstTime() {
            return this.firstTime;
        }

        public Instant endTime() {
            return this.endTime;
        }

        public Duration elapsedTime() {
            return this.elapsedTime;
        }

        public long samplesCount() {
            return this.samplesCount;
        }

        public double samplesPerSecond() {
            return this.samplesPerSecond;
        }

        public long errorsCount() {
            return this.errorsCount;
        }

        public Duration minSampleTime() {
            return this.minSampleTime;
        }

        public Duration maxSampleTime() {
            return this.maxSampleTime;
        }

        public Duration meanSampleTime() {
            return this.meanSampleTime;
        }

        public Duration sampleTimePercentile90() {
            return this.sampleTimePercentile90;
        }

        public Duration sampleTimePercentile95() {
            return this.sampleTimePercentile95;
        }

        public Duration sampleTimePercentile99() {
            return this.sampleTimePercentile99;
        }

        public long receivedBytes() {
            return this.receivedBytes;
        }

        public double receivedBytesPerSecond() {
            return this.receivedBytesPerSecond;
        }

        public long sentBytes() {
            throw new UnsupportedOperationException("BlazeMeter API does not provide an efficient way to get this value.");
        }

        public double sentBytesPerSecond() {
            throw new UnsupportedOperationException("BlazeMeter API does not provide an efficient way to get this value.");
        }
    }
}

