/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.dsl.nodespecific;

import uk.org.webcompere.modelassert.json.condition.Not;
import uk.org.webcompere.modelassert.json.condition.NumberCondition;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.NumberComparisonDsl;

public interface NumberNodeDsl<A>
extends Satisfies<A>,
NumberComparisonDsl<A> {
    default public A isGreaterThanInt(int number) {
        return this.satisfiesNumberCondition(new NumberCondition<Integer>(Integer.class, number, NumberCondition.Comparison.GREATER_THAN));
    }

    default public A isGreaterThanDouble(double number) {
        return this.satisfiesNumberCondition(new NumberCondition<Double>(Double.class, number, NumberCondition.Comparison.GREATER_THAN));
    }

    default public A isGreaterThanOrEqualToDouble(double number) {
        return this.satisfiesNumberCondition(new NumberCondition<Double>(Double.class, number, NumberCondition.Comparison.GREATER_THAN_OR_EQUAL));
    }

    default public A isGreaterThanOrEqualToInt(int number) {
        return this.satisfiesNumberCondition(new NumberCondition<Integer>(Integer.class, number, NumberCondition.Comparison.GREATER_THAN_OR_EQUAL));
    }

    default public A isGreaterThanLong(long number) {
        return this.satisfiesNumberCondition(new NumberCondition<Long>(Long.class, number, NumberCondition.Comparison.GREATER_THAN));
    }

    default public A isGreaterThanOrEqualToLong(long number) {
        return this.satisfiesNumberCondition(new NumberCondition<Long>(Long.class, number, NumberCondition.Comparison.GREATER_THAN_OR_EQUAL));
    }

    default public A isLessThanOrEqualToInt(int number) {
        return this.satisfiesNumberCondition(new NumberCondition<Integer>(Integer.class, number, NumberCondition.Comparison.LESS_THAN_OR_EQUAL));
    }

    default public A isLessThanOrEqualToLong(long number) {
        return this.satisfiesNumberCondition(new NumberCondition<Long>(Long.class, number, NumberCondition.Comparison.LESS_THAN_OR_EQUAL));
    }

    default public A isLessThanOrEqualToDouble(double number) {
        return this.satisfiesNumberCondition(new NumberCondition<Double>(Double.class, number, NumberCondition.Comparison.LESS_THAN_OR_EQUAL));
    }

    default public A isNumberEqualTo(Number number) {
        return this.satisfiesNumberCondition(new NumberCondition<Number>(number, NumberCondition.Comparison.EQUAL_TO));
    }

    default public A isNumberNotEqualTo(Number number) {
        return this.satisfiesNumberCondition(Not.not(new NumberCondition<Number>(number, NumberCondition.Comparison.EQUAL_TO)));
    }

    default public A isLessThanInt(int number) {
        return this.satisfiesNumberCondition(new NumberCondition<Integer>(Integer.class, number, NumberCondition.Comparison.LESS_THAN));
    }

    default public A isLessThanLong(long number) {
        return this.satisfiesNumberCondition(new NumberCondition<Long>(Long.class, number, NumberCondition.Comparison.LESS_THAN));
    }

    default public A isLessThanDouble(double number) {
        return this.satisfiesNumberCondition(new NumberCondition<Double>(Double.class, number, NumberCondition.Comparison.LESS_THAN));
    }

    default public A isInteger() {
        return this.satisfiesNumberCondition(new NumberCondition<Integer>(Integer.class, 0, NumberCondition.Comparison.NONE));
    }

    default public A isLong() {
        return this.satisfiesNumberCondition(new NumberCondition<Long>(Long.class, 0L, NumberCondition.Comparison.NONE));
    }

    default public A isDouble() {
        return this.satisfiesNumberCondition(new NumberCondition<Double>(Double.class, 0.0, NumberCondition.Comparison.NONE));
    }
}

