/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;

public class MatchesTextCondition
implements Condition {
    private Predicate<String> predicate;
    private String conditionName;

    public MatchesTextCondition(Pattern pattern) {
        this(pattern, "Text must match " + pattern.pattern());
    }

    public MatchesTextCondition(Pattern pattern, String conditionName) {
        this.predicate = text -> pattern.matcher((CharSequence)text).matches();
        this.conditionName = conditionName;
    }

    public MatchesTextCondition(String conditionName, Predicate<String> predicate) {
        this.predicate = predicate;
        this.conditionName = conditionName;
    }

    public static MatchesTextCondition textContains(String contains) {
        return new MatchesTextCondition(Pattern.compile(".*" + Pattern.quote(contains) + ".*"), "Text contains " + contains);
    }

    public static MatchesTextCondition textStartsWith(String substring) {
        return new MatchesTextCondition(Pattern.compile(Pattern.quote(substring) + ".*"), "Text starts with " + substring);
    }

    public static MatchesTextCondition textMatches(Pattern pattern) {
        return new MatchesTextCondition(pattern);
    }

    @Override
    public Result test(JsonNode json) {
        if (!json.isTextual()) {
            return new Result(this.describe(), json.getNodeType().toString(), false);
        }
        String text = json.asText();
        return new Result(this.describe(), text, this.predicate.test(text));
    }

    @Override
    public String describe() {
        return this.conditionName;
    }
}

