/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.nio.file.Path;
import uk.org.webcompere.modelassert.json.JsonProvider;

public class JsonProviders {
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    private static ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static JsonProvider<String> jsonStringProvider() {
        return arg_0 -> ((ObjectMapper)OBJECT_MAPPER).readTree(arg_0);
    }

    public static JsonProvider<Object> jsonObjectProvider() {
        return object -> (JsonNode)OBJECT_MAPPER.convertValue(object, JsonNode.class);
    }

    public static JsonProvider<File> jsonFileProvider() {
        return arg_0 -> ((ObjectMapper)OBJECT_MAPPER).readTree(arg_0);
    }

    public static JsonProvider<Path> jsonPathProvider() {
        return path -> OBJECT_MAPPER.readTree(path.toFile());
    }

    public static JsonProvider<String> yamlStringProvider() {
        return arg_0 -> ((ObjectMapper)YAML_MAPPER).readTree(arg_0);
    }

    public static JsonProvider<File> yamlFileProvider() {
        return arg_0 -> ((ObjectMapper)YAML_MAPPER).readTree(arg_0);
    }

    public static JsonProvider<Path> yamlPathProvider() {
        return path -> YAML_MAPPER.readTree(path.toFile());
    }
}

