/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition.array;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;
import uk.org.webcompere.modelassert.json.condition.array.ArrayElementCondition;
import uk.org.webcompere.modelassert.json.condition.array.ArrayElementConditionAdapter;
import uk.org.webcompere.modelassert.json.condition.array.Multiset;

public class LooseComparison {
    private List<ArrayElementCondition> arrayElementConditions;
    private Supplier<String> description;

    public LooseComparison(List<ArrayElementCondition> arrayElementConditions, Supplier<String> description) {
        this.arrayElementConditions = arrayElementConditions;
        this.description = description;
    }

    public static LooseComparison fromConditions(List<Condition> arrayElementConditions, Supplier<String> description) {
        return new LooseComparison(arrayElementConditions.stream().map(ArrayElementConditionAdapter::new).collect(Collectors.toList()), description);
    }

    public Result looseComparison(ArrayNode arrayNode) {
        List<Match> matches = IntStream.range(0, this.arrayElementConditions.size()).mapToObj(index -> this.calcMatches(index, arrayNode)).collect(Collectors.toList());
        while (!matches.isEmpty()) {
            matches.sort(Comparator.comparing(Match::size));
            if (((Match)matches.get(0)).size() == 0) {
                return this.explainMismatches(matches);
            }
            this.removeLeastOccurringCounterpart(matches);
        }
        return new Result(this.describe(), "all matched", true);
    }

    private void removeLeastOccurringCounterpart(List<Match> matches) {
        Multiset multiset = new Multiset();
        matches.stream().flatMap(Match::streamCounterparts).forEach(multiset::add);
        int leastFoundIndex = multiset.entries().min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElseThrow(() -> new IllegalStateException("Cannot have no elements"));
        Match smallestMatch = matches.stream().filter(match -> match.contains(leastFoundIndex)).min(Comparator.comparing(Match::size)).orElseThrow(() -> new IllegalStateException("Cannot have no elements"));
        matches.remove(smallestMatch);
        matches.forEach(match -> match.remove(leastFoundIndex));
    }

    private Result explainMismatches(List<Match> matches) {
        matches.sort(Comparator.comparing(Match::getIndex));
        return new Result(this.describe(), "No matches for:\n" + matches.stream().filter(match -> match.size() == 0).map(match -> "Index " + match.getIndex() + ": " + this.arrayElementConditions.get(match.getIndex()).describe()).collect(Collectors.joining("\n")), false);
    }

    private Match calcMatches(int index, ArrayNode arrayNode) {
        Match match = new Match(index);
        for (int i = 0; i < arrayNode.size(); ++i) {
            if (!this.arrayElementConditions.get(index).test(arrayNode.get(i), index).isPassed()) continue;
            match.add(i);
        }
        return match;
    }

    private Supplier<String> describe() {
        return this.description;
    }

    private static class Match {
        private int index;
        private Set<Integer> counterPartIndices = new HashSet<Integer>();

        public Match(int index) {
            this.index = index;
        }

        public int size() {
            return this.counterPartIndices.size();
        }

        public int getIndex() {
            return this.index;
        }

        public void add(int counterPart) {
            this.counterPartIndices.add(counterPart);
        }

        public void remove(int counterPart) {
            this.counterPartIndices.remove(counterPart);
        }

        public Stream<Integer> streamCounterparts() {
            return this.counterPartIndices.stream();
        }

        public boolean contains(int counterpart) {
            return this.counterPartIndices.contains(counterpart);
        }
    }
}

