/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;
import uk.org.webcompere.modelassert.json.condition.NumberCondition;
import uk.org.webcompere.modelassert.json.dsl.Satisfies;
import uk.org.webcompere.modelassert.json.dsl.nodespecific.NumberComparisonDsl;

public class HasSize
implements Condition {
    private Condition sizeCondition;

    public HasSize(int requiredSize) {
        this.sizeCondition = new NumberCondition<Integer>(requiredSize, NumberCondition.Comparison.EQUAL_TO);
    }

    private HasSize(Condition sizeCondition) {
        this.sizeCondition = sizeCondition;
    }

    public static <A> NumberComparisonDsl<A> sizeOf(Satisfies<A> parentAssertion) {
        return condition -> parentAssertion.satisfies(new HasSize(condition));
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Node type is used in place of instanceof for the switch")
    public Result test(JsonNode json) {
        switch (json.getNodeType()) {
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)json;
                return new Result(this.describe(), "Array of size " + arrayNode.size(), this.testNumber(arrayNode.size()));
            }
            case OBJECT: {
                ObjectNode objectNode = (ObjectNode)json;
                return new Result(this.describe(), "Object of size " + objectNode.size(), this.testNumber(objectNode.size()));
            }
            case STRING: {
                return new Result(this.describe(), "Text of length " + json.asText().length(), this.testNumber(json.asText().length()));
            }
        }
        return new Result(this.describe(), json.getNodeType().toString(), false);
    }

    private boolean testNumber(int number) {
        return this.sizeCondition.test((JsonNode)new IntNode(number)).isPassed();
    }

    @Override
    public String describe() {
        return "string, array or object where size " + this.sizeCondition.describe();
    }
}

