/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.util;

import lombok.NonNull;
import uk.num.numlib.exc.NumInvalidParameterException;

public interface LookupGenerator {
    public String getIndependentLocation(int var1) throws NumInvalidParameterException;

    public String getHostedLocation(int var1) throws NumInvalidParameterException;

    public boolean isDomainRoot();

    public String getPopulatorLocation(int var1) throws NumInvalidParameterException;

    public String getRootIndependentLocation(int var1) throws NumInvalidParameterException;

    public String getRootHostedLocation(int var1) throws NumInvalidParameterException;

    public String getRootIndependentLocationNoModuleNumber(TrailingDot var1);

    public String getRootHostedLocationNoModuleNumber(TrailingDot var1);

    public static final class NumUriComponents {
        @NonNull
        private final String domain;
        private final int moduleNumber;
        @NonNull
        private final String path;
        private final String params;

        public String toString() {
            if (this.params == null) {
                return "num://" + this.domain + ":" + this.moduleNumber + this.path;
            }
            return "num://" + this.domain + ":" + this.moduleNumber + this.path + "?" + this.params;
        }

        public NumUriComponents(@NonNull String domain, int moduleNumber, @NonNull String path, String params) {
            if (domain == null) {
                throw new NullPointerException("domain is marked @NonNull but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked @NonNull but is null");
            }
            this.domain = domain;
            this.moduleNumber = moduleNumber;
            this.path = path;
            this.params = params;
        }

        @NonNull
        public String getDomain() {
            return this.domain;
        }

        public int getModuleNumber() {
            return this.moduleNumber;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }

        public String getParams() {
            return this.params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NumUriComponents)) {
                return false;
            }
            NumUriComponents other = (NumUriComponents)o;
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            if (this.getModuleNumber() != other.getModuleNumber()) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$params = this.getParams();
            String other$params = other.getParams();
            return !(this$params == null ? other$params != null : !this$params.equals(other$params));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            result = result * 59 + this.getModuleNumber();
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            return result;
        }
    }

    public static enum TrailingDot {
        ADD_TRAILING_DOT,
        NO_TRAILING_DOT;

    }
}

