/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.service;

import lombok.NonNull;
import uk.num.numlib.dns.DNSServices;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;
import uk.num.numlib.exc.RrSetNoHeadersException;
import uk.num.numlib.service.LoadRecordResponse;
import uk.num.numlib.service.LookupServiceHelper;
import uk.num.numlib.util.BaseLookupGenerator;
import uk.num.numlib.util.DomainLookupGenerator;
import uk.num.numlib.util.EmailLookupGenerator;

public class HostedRecordLookupService {
    private final LookupServiceHelper helper;

    public HostedRecordLookupService(DNSServices dnsServices) {
        this.helper = new LookupServiceHelper(dnsServices);
    }

    public LoadRecordResponse loadRecord(@NonNull String numIdName, @NonNull String path, int module, int timeoutMs) throws NumInvalidParameterException, NumInvalidDNSQueryException, RrSetIncompleteException, RrSetNoHeadersException, RrSetHeaderFormatException {
        if (numIdName == null) {
            throw new NullPointerException("numIdName is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        LookupServiceHelper.validateParameters(numIdName, path, module, timeoutMs);
        BaseLookupGenerator generator = numIdName.contains("@") ? new EmailLookupGenerator(numIdName + path) : new DomainLookupGenerator(numIdName + path);
        return this.helper.loadRecordFromZone(timeoutMs, generator.getHostedLocation(module));
    }
}

