/*
 * Decompiled with CFR 0.152.
 */
package uk.num.validators;

import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import uk.num.numlib.util.DomainLookupGenerator;
import uk.num.numlib.util.LookupGenerator;
import uk.num.validators.NumDomainValidator;
import uk.num.validators.NumEmailAddressValidator;
import uk.num.validators.NumModuleNumberValidator;
import uk.num.validators.NumUriPathValidator;
import uk.num.validators.ValidationResult;

public class NumUriValidator {
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String NUM_PROTOCOL_PREFIX = "num://";

    private NumUriValidator() {
    }

    public static ValidationResult validate(@NonNull String domain, int moduleNumber, @NonNull String path) {
        if (domain == null) {
            throw new NullPointerException("domain is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        return NumUriValidator.validate(new LookupGenerator.NumUriComponents(domain, moduleNumber, path, null).toString());
    }

    public static ValidationResult validate(String uri) {
        ValidationResult result;
        block16: {
            result = new ValidationResult();
            try {
                String independentLocation;
                DomainLookupGenerator lookupGenerator;
                String hostedLocation;
                String withoutProtocol;
                if (uri == null) {
                    result.addMessage(ValidationResult.ErrorCode.NULL_UNACCEPTABLE, "uri");
                    break block16;
                }
                if (uri.contains(PROTOCOL_SEPARATOR)) {
                    if (!uri.toLowerCase().startsWith(NUM_PROTOCOL_PREFIX)) {
                        result.addMessage(ValidationResult.ErrorCode.INVALID_NUM_PROTOCOL_PREFIX, StringUtils.substringBefore((String)uri, (String)NUM_PROTOCOL_PREFIX));
                    }
                    withoutProtocol = StringUtils.substringAfter((String)uri, (String)PROTOCOL_SEPARATOR);
                } else {
                    withoutProtocol = uri;
                }
                String[] parts = withoutProtocol.split("/");
                String[] domainAndModuleNumber = parts[0].split(":");
                if (domainAndModuleNumber[0].contains("@")) {
                    result.merge(NumEmailAddressValidator.validate(domainAndModuleNumber[0]));
                } else {
                    result.merge(NumDomainValidator.validate(domainAndModuleNumber[0]));
                }
                if (domainAndModuleNumber.length == 2) {
                    result.merge(NumModuleNumberValidator.validate(domainAndModuleNumber[1]));
                }
                if (domainAndModuleNumber.length > 2) {
                    result.addMessage(ValidationResult.ErrorCode.TOO_MANY_COLONS, parts[0]);
                }
                int moduleNumber = 0;
                if (domainAndModuleNumber.length > 1) {
                    try {
                        moduleNumber = Integer.parseInt(domainAndModuleNumber[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((hostedLocation = (lookupGenerator = new DomainLookupGenerator(uri)).getHostedLocation(moduleNumber)).getBytes().length > 253) {
                    result.addMessage(ValidationResult.ErrorCode.HOSTED_DOMAIN_NAME_TOO_LONG, hostedLocation);
                }
                if ((independentLocation = lookupGenerator.getIndependentLocation(moduleNumber)).getBytes().length > 253) {
                    result.addMessage(ValidationResult.ErrorCode.INDEPENDENT_DOMAIN_NAME_TOO_LONG, independentLocation);
                }
                if (parts.length > 1) {
                    CharSequence[] tailParts = Arrays.copyOfRange(parts, 1, parts.length);
                    String path = "/" + String.join((CharSequence)"/", tailParts);
                    result.merge(NumUriPathValidator.validate(path));
                }
            }
            catch (Exception e) {
                result.addMessage(ValidationResult.ErrorCode.EXCEPTION_MESSAGE, e.getMessage());
            }
        }
        return result;
    }
}

