/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.service;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.xbill.DNS.Record;
import uk.num.numlib.dns.DNSServices;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;
import uk.num.numlib.exc.RrSetNoHeadersException;
import uk.num.numlib.service.LoadRecordResponse;

class LookupServiceHelper {
    public static final int MAX_SANE_NUMID_LENGTH = 255;
    private final DNSServices dnsServices;

    public static void validateParameters(@NonNull String numIdName, @NonNull String path, int module, int timeoutMs) throws NumInvalidParameterException {
        if (numIdName == null) {
            throw new NullPointerException("numIdName is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        if (StringUtils.isBlank((CharSequence)numIdName) || numIdName.length() > 255) {
            throw new NumInvalidParameterException(String.format("numIdName is null, blank, or longer than 255 characters: '%s'", numIdName));
        }
        if (path.length() > 255) {
            throw new NumInvalidParameterException(String.format("path is longer than 255 characters: '%s'", path));
        }
        if (module < 0) {
            throw new NumInvalidParameterException("module number cannot be negative.");
        }
        if (timeoutMs <= 0) {
            throw new NumInvalidParameterException("timeoutMs cannot be negative or zero.");
        }
    }

    public LoadRecordResponse loadRecordFromZone(int timeoutMs, @NonNull String location) throws NumInvalidDNSQueryException, RrSetIncompleteException, RrSetNoHeadersException, RrSetHeaderFormatException {
        if (location == null) {
            throw new NullPointerException("location is marked @NonNull but is null");
        }
        try {
            Record[] records;
            DNSServices.GetRecordResponse response = this.dnsServices.getRecordFromDnsNoCache(location, timeoutMs);
            if (response != null && (records = response.getRecords()) != null && records.length > 0) {
                String record = this.dnsServices.rebuildTXTRecordContent(records);
                return new LoadRecordResponse(response.isSigned(), record);
            }
        }
        catch (NumNoRecordAvailableException e) {
            return null;
        }
        return null;
    }

    public LookupServiceHelper(DNSServices dnsServices) {
        this.dnsServices = dnsServices;
    }
}

